% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storedResults.R
\docType{data}
\name{obsSep2006_2007}
\alias{obsSep2006_2007}
\title{Observed sea ice September 2006-2007}
\format{array of dimension of 2 x 12 x 304 x 448 (year x month x longitude
x latitude)}
\usage{
obsSep2006_2007
}
\description{
The object \code{observed} is an array obtained from the function
\code{readMonthlyBS}for startYear = 2006 and endYear = 2007. It gives the
observed sea ice concentrations arranged in an array of dimension of year x
month x lon x lat. The observations are from the monthly sea ice
concentration obtained from the National Aeronautics and Space Administration
(NASA) satellites Nimbus-7 SMMR and DMSP SSM/I-SSMIS and processed by the
bootstrap algorithm. The results are distributed by the National Snow and Ice
Data Center (Comiso 2017).
}
\examples{
data(obsSep2006_2007)
dim(obsSep2006_2007)
}
\references{
Comiso, J., 2017: Bootstrap sea ice concentrations
            from Nimbus-7 SMMR and DMSP SSM/I-SSMIS. version 3.
            {Boulder, Colorado USA: NASA National Snow and Ice Data Center
            Distributed Active Archive Center}
}
\keyword{datasets}
