% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genPolys.R
\name{indiv_poly}
\alias{indiv_poly}
\title{Generate an individual polygon from a set of points}
\usage{
indiv_poly(pts, r, loop_r, reg_info, t1 = NULL, t2 = NULL,
  poly_name = "unspecified")
}
\arguments{
\item{pts}{matrix with two columns giving the coordinates of the
generated points}

\item{r}{integer specifying the region}

\item{loop_r}{boolean indicating whether the points are going in a loop}

\item{reg_info}{a \code{reg_info} list (see documentation for \code{reg_info})}

\item{t1}{index of first transition point under consideration in
\code{pts} matrix, NULL if \code{loop_r == TRUE}}

\item{t2}{index of second transition point under consideration in
\code{pts} matrix, NULL if \code{loop_r == TRUE}}

\item{poly_name}{string giving name of polygon}
}
\description{
Generate an individual polygon from a set of points
}
