% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitContours.R
\name{fit_cont_pars}
\alias{fit_cont_pars}
\title{Sets up MCMC to fit the parameters of the contour Model in R, then runs
the sampler in C++}
\usage{
fit_cont_pars(r, n_iter, y_obs, reg_info, dists = NULL,
  sigma_min = 0.01, sigma0_lb = NULL, sigma0_ub = NULL,
  xU_prop_sd_def = 0.03, mu_ini = NULL, mu0 = NULL, lambda0 = NULL,
  sigma_ini = NULL, sigma_prop_cov = NULL, sigma_sp = 25,
  rho_ini = 0.5, rho0_lb = 0, rho0_ub = 0.99, rho_prop_sd = 0.01,
  w = 20)
}
\arguments{
\item{r}{number indicating which region in the \code{reg_info} list is being
considered}

\item{n_iter}{number of iterations to run the MCMC, must be a multiple of \code{w}}

\item{y_obs}{output of \code{y_obs} function. This is a list of matrices,
one per region, giving the observed \eqn{y} values. Each row
corresponds to the lines and each column corresponds to
a training year}

\item{reg_info}{a \code{reg_info} list (see documentation for \code{reg_info})}

\item{dists}{symmetric matrix of the same dimension as the number of
lines being used, specifying distances among indices.
Defaults to \code{NULL}, which means atrix will be computed by
the \code{dist_mat} function}

\item{sigma_min}{minimum value for all \eqn{\sigma} parameters.
Typically close to but not exactly zero (defaults to 0.01).
Not used if \code{sigma0_lb} is set to \code{NULL}}

\item{sigma0_lb}{vector of the same length as the number of lines which
specifies the lower bound of the uniform prior for each sigma
value. Defaults to \code{NULL}, meaning \code{sigma0_lb} is
set to be a vector with all values set to \code{sigmaMin}}

\item{sigma0_ub}{vector of the same length as the number of lines which
specifies the upper bound of the uniform prior for each sigma
value. Defaults to \code{NULL}}

\item{xU_prop_sd_def}{Standard deviation for proposals for xU when xU can take on
an infinite set of values}

\item{mu_ini}{vector of the same length as the number of lines which
specifies the values from which each element of \eqn{\mu} will
be initialized in the MCMC. Defaults to \code{NULL}, meaning
\eqn{\mu} will be initialized with the mean of the observed y's}

\item{mu0}{vector of the same length as the number of lines which specifies
the prior mean for \eqn{\mu}. Defaults to \code{NULL}, meaning
each element in \code{mu0} will be set to be in the middle of its
corresponding line}

\item{lambda0}{matrix of the same dimension as the number of lines which
specifices the prior covariance matrix for \eqn{\mu}. Defaults
to \code{NULL}, which gives a diagonal matrix with diagonal
elements corresponding to the variance that would be required
for 80% of the data to fall between the minimum and maximum
values of the corresponding line if the data were normally
distributed.}

\item{sigma_ini}{vector of the same length as the number of lines which
specifies the values from which each element in \eqn{\Sigma}
will be initialized from. Defaults to \code{NULL}, meaning
each element of \eqn{\Sigma} will be initialized with
the observed standard deviation of its corresponding y's,
bounded by \code{sigma0_lb} and \code{sigma0_ub}.}

\item{sigma_prop_cov}{covariance matrix of the same length as the number of
lines that is used in sampling \eqn{\Sigma} values.
Defaults to \code{NULL}, meaning a diagonal matrix
is used. The elements on the diagonal of this matrix are
generally set to have value \code{sigma_ini}/20 unless
the corresponding observed y's have zero variance, in
which case these values are set to 0.1.}

\item{sigma_sp}{integer specifying how many elements in the \eqn{\Sigma}
matrix should be sampled together in the MCMC. Defaults to
25.}

\item{rho_ini}{double between 0 and 1 from which the value of \code{rho} will
be initialized. Defaults to 0.5}

\item{rho0_lb}{double between 0 and 1 which gives the lower bound of the
uniform prior for \code{rho}. Detauls to 0.}

\item{rho0_ub}{double between 0 and 1 which gives the upper bound of the
uniform prior for \code{rho}. Defaults to 1.}

\item{rho_prop_sd}{standard deviation for the normal proposal distribution used
when proposing value for \code{rho} in the sampler. Defaults
to 0.01}

\item{w}{integer specifying how many samples of the parameters will be
maintained. Samples from every w-th iteration is stored.}
}
\value{
List that gives the values of the MCMC chain for
        \code{xU}, \code{mu}, \code{sigma} and \code{rho} along with
        indicators of acceptance on each iteration: \code{xURate},
        \code{sigmaRate}, and \code{rhoRate}. Background information
        is also outputted including the upper and lower bounds for
        unobserved x's (\code{xU_lb}, \code{xU_ub}), vectors giving
        the first and last indices of each grouping in sampling \eqn{\Sigma}
        (\code{sigma_ind_1},\code{sigma_ind_2}), the distance matrix
        (\code{dists}), and the integer specifying how many samples of the
        parameters will be maintained \code{w}
}
\description{
Sets up MCMC to fit the parameters of the contour Model in R, then runs
the sampler in C++
}
\examples{
\dontrun{
y_obs <- y_obs(maps = obs_maps, reg_info)
res <- fit_cont_pars(r = 3, n_iter = 1000, y_obs, reg_info)
}
}
