% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappings.R
\name{createMapping}
\alias{createMapping}
\title{Map a set of observations and predictions}
\usage{
createMapping(startYear, endYear, obsStartYear, predStartYear, observed,
  predicted, regions, month, level, datTypeObs, datTypePred, plotting = FALSE,
  obsOnly = FALSE, predOnly = FALSE, nX = 304, nY = 448, xmn = -3850,
  xmx = 3750, ymn = -5350, ymx = 5850)
}
\arguments{
\item{startYear}{first year to be mapped}

\item{endYear}{last year to be mapped}

\item{obsStartYear}{year in which observation array starts}

\item{predStartYear}{year in which prediction array starts}

\item{observed}{array of observed values of dimension year x longitude x latitude}

\item{predicted}{array of predicted values of dimension year x longitude x latitude}

\item{regions}{region information list (see detail)}

\item{month}{month under consideration}

\item{level}{concentration level for which to build contour}

\item{datTypeObs}{string of either "bootstrap" or "simple" indicating the file type of the observation (see details)}

\item{datTypePred}{string of either "gfdl" or "simple" indicating the file type of the prediction (see details)}

\item{plotting}{boolean indicatng whether maps should be plotted (defaults to false)}

\item{obsOnly}{run mapping only for observations}

\item{predOnly}{run mapping only for predictions}

\item{nX}{dimension in the x (defaults to value for Northern Polar stereographic grid: 304)}

\item{nY}{dimension in the y (defaults to value for Northern Polar stereographic grid: 448)}

\item{xmn}{min x value (defaults to value for Northern Polar stereographic grid: -3850)}

\item{xmx}{max x value (defaults to value for Northern Polar stereographic grid: 3750)}

\item{ymn}{min y value (defaults to value for Northern Polar stereographic grid: -5350)}

\item{ymx}{max y value (defaults to value for Northern Polar stereographic grid: 5850)}
}
\value{
\code{map} object (see details)
}
\description{
Finds all the mappings for a set of observations and predictions often over multiple years
}
\details{
The object \code{maps} is obtained from running the \code{createMapping} function. It is a list of five objects where
\code{startYear} and \code{endYear} give first year, and last year that were mapped. The variables \code{obsList} and \code{predList}
are lists of arrays with one 3-dimensional array for each region. The first dimension is for the year. The other two dimensions
are for the fixed points' y-coordinates, the mapped points' x-coordinates, the mapped points' y-coordinates, the length of the mapping vectors in the
x-direction, the length of the vectors in the y-direction, and the angles of the mapping vectors.

 A region information list is a list six objects: \code{regions}, \code{lines}, \code{out}, \code{centRegion}, \code{centLines}, and
\code{centFrom}. The first three objects are ordered lists giving information about each of the regions that will be mapped outside the
Central Arctic region. The variable \code{regions} gives \code{SpatialPolygons} objects for the corresponding regions and the variable \code{lines}
 gives the \code{SpatialLines} objects for the corresponding fixed lines. The variable \code{out} gives \code{SpatialPolygons} objects that are outside the corresponding regions,
 but that border the fixed lines. These are used when building new polygons to determine if points are being mapped outside the region of interest.
 The variable \code{centRegions} is the \code{SpatialPolygons} object corresponding to the central Arctic region, \code{centLines} is the \code{SpatialLines} object for the fixed line,
 and \code{centFrom} is an n x 2 matrix with each row repeatedly giving the coordinates of the center point from which mapping vectors will emanate.
 The package contains \code{regionInfo} in the \code{regionInfo.rda} file, which can be used unless you want to define your own regions.

For \code{datTypeObs = "simple"} and \code{datTypePred = "simple"} the values in the \code{observed} and \code{predicted} arrays are
indicators of whether the grid box contains ice (1: ice-covered, 0: no ice, NA: land).
If \code{datTypePred = "gfdl"} or \code{datTypeObs  = "bootstrap"}, the values in the \code{observed} and \code{predicted} arrays correspond
to the raw ice concentrations values observed or predicted (including indicators for missing data, land etc.).
If \code{datTypePred = "gfdl"}, the predictions are
formatted as in the CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model produced by the National Oceanic and Atmospheric Administration’s
Geophysical Fluid Dynamics Laboratory and converted to a Polar Stereographic grid (Vecchi et al. 2014; Msadek et al. 2014).
If \code{datTypeObs = "bootstrap"} the array values are assumed to be from the monthly sea ice concentration
obtained from the National Aeronautics and Space Administration (NASA) satellites Nimbus-7
SMMR and DMSP SSM/I-SSMIS and processed by the bootstrap algorithm. Weights for
converting to a polar stereograhic grid were obtained from the spherical coordinate remapping and interpolation package (SCRIP) (Jones 1997).
}
\examples{
\dontrun{
createMapping(startYear = 1981, endYear = 1981, obsStartYear = 1981, predStartYear = 1980,
             observed = obsFeb19811982, predicted = emFeb19811982,
             regions = regionInfo, month = 2, level = 15,
             datTypeObs = "bootstrap", datTypePred = "gfdl", plotting = TRUE)
}
}
\references{
Bootstrap sea ice concentration:
Comiso, J., 2000, updated 2015: Bootstrap sea ice concentrations from Nimbus-7 SMMR and
DMSP SSM/I-SSMIS. version 2. \url{http://nsidc.org/data/nsidc-0079}

CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model:
Vecchi, Gabriel A., et al.
\href{http://journals.ametsoc.org/doi/abs/10.1175/JCLI-D-14-00158.1}{"On the seasonal forecasting of regional tropical}
cyclone activity." Journal of Climate 27.21 (2014): 7994-8016.

Msadek, R., et al.
\href{http://onlinelibrary.wiley.com/doi/10.1002/2014GL060799/full}{"Importance of initial conditions in seasonal predictions of Arctic sea ice extent."}
 Geophysical Research Letters 41.14 (2014): 5208-5215.

National Center for Atmospheric Research, 2017: Earth system grid at NCAR. \url{https://www.
earthsystemgrid.org/home.html}.

Jones, P.W. "A user’s guide for SCRIP: A spherical coordinate remapping and interpolation package."
Los Alamos National Laboratory, Los Alamos, NM (1997).
}
