% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.read.entry.R
\name{ISRaD.read.entry}
\alias{ISRaD.read.entry}
\title{ISRaD.read.entry}
\usage{
ISRaD.read.entry(
  entry,
  template_file = system.file("extdata", "ISRaD_Master_Template.xlsx", package =
    "ISRaD")
)
}
\arguments{
\item{entry}{ISRaD data object.}

\item{template_file}{Directory path and name of template file to use (defaults to the ISRaD_Master_Template file built into the package).}
}
\description{
Reads ISRaD data object from Excel file in standard template format
}
\examples{
\donttest{
# Load example dataset Gaudinski_2001
entry <- ISRaD::Gaudinski_2001
ISRaD.save.entry(
  entry = entry,
  template_file = system.file("extdata", "ISRaD_Master_Template.xlsx", package = "ISRaD"),
  outfile = file.path(tempdir(), "Gaudinski_2001.xlsx")
)
# Read in .xlsx file
ISRaD.read.entry(file.path(tempdir(), "Gaudinski_2001.xlsx"))
}
}
\author{
J. Beem-Miller
}
