% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.getdata.R
\name{ISRaD.getdata}
\alias{ISRaD.getdata}
\title{ISRaD.getdata}
\usage{
ISRaD.getdata(
  directory,
  dataset = "full",
  extra = FALSE,
  force_download = FALSE
)
}
\arguments{
\item{directory}{Location of ISRaD_database_files folder. If not found, it will be created.}

\item{dataset}{Specify which data you want. Options are c("full", flux","interstitial","incubation","fraction","layer")}

\item{extra}{TRUE/FALSE. If TRUE, the ISRaD_extra object will be returned. If FALSE, ISRaD_data will be returned. Default is FALSE.}

\item{force_download}{TRUE/FALSE. If ISRaD_database files already exist in the specified directory, new data will not be downloaded by default. If force_download is set to TRUE, the newest data from github will be downloaded and overwrite any existing files.}
}
\value{
ISRaD data object
}
\description{
Retrieves most recent version of ISRaD data from github
}
\examples{
# Return full dataset ("full")
ISRaD_full <- ISRaD.getdata(tempdir(), dataset = "full", extra = FALSE)
# Return full dataset plus "extra" filled data
ISRaD_extra <- ISRaD.getdata(tempdir(), dataset = "full", extra = TRUE)
# Return only fraction data, including filled fraction data
ISRaD_fractions <- ISRaD.getdata(tempdir(), dataset = "fraction", extra = TRUE)
}
