## ------------------------------------------------------------------------
library(IRTpp)

data <- simulateTest(model="2PL",items=10,individuals=1000)

alpha.cronbach(data$test)

## ------------------------------------------------------------------------
curve <- alpha.c(data$test)
curve

## ------------------------------------------------------------------------
biserial.cor(rowSums(data$test), data$test[,1])


## ------------------------------------------------------------------------
fit <- irtpp(dataset = data$test,model = "2PL")

fit=parameter.matrix(fit$z)

information(fit, c(-2, 0))
information(fit, c(0, 2), items = c(3, 5))


## ------------------------------------------------------------------------
gutt(data$test)

## ------------------------------------------------------------------------
x <- c(12,8,16,9)
Yule(x)

## ------------------------------------------------------------------------
x2 = matrix(x,ncol=2)
phi(x2)

## ------------------------------------------------------------------------
x <- rnorm(100)
y <- sample(1:5,100,replace=T)
cor(x, y) 
polyserial.cor(x, y) 

## ------------------------------------------------------------------------
an.parallel(data$test, iterations = 100, centile = 99, seed = 12)


## ------------------------------------------------------------------------
data_cor <- cor(data$test)

an.parallel(mat = data_cor, n = 1000, iterations = 100, centile = 99, seed = 12)


