% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.R
\name{reliability}
\alias{reliability}
\title{Marginal reliability coefficient of IRT}
\usage{
reliability(x, level = "test")
}
\arguments{
\item{x}{A model fit object from either \code{IRTest_Dich}, \code{IRTest_Poly}, or \code{IRTest_Mix}.}

\item{level}{A character value of either \code{"test"} or \code{"item"}
which is the level of reliability coefficient(s) to be returned.
The default is \code{"test"}.}
}
\value{
Estimated marginal reliability coefficient.
}
\description{
Marginal reliability coefficient of IRT
}
\details{
\describe{
In accordance with the concept of \emph{reliability} in classical test theory (CTT),
this function calculates the IRT reliability coefficient.
\item{
The basic concept and formula of the reliability coefficient can be expressed as follows (Kim, Feldt, 2010):
}{
An observed score of Item \eqn{i} (\eqn{X_i}) is decomposed as the sum of a true score \eqn{T_i} and an error \eqn{e_i}.
Then, with the assumption of \eqn{\sigma_{T_{i}e_{j}}=\sigma_{e_{i}e_{j}}=0}, the reliability coefficient of a test is defined as;
\deqn{\rho_{TX}=\rho_{XX^{'}}=\frac{\sigma_{T}^{2}}{\sigma_{X}^{2}}=\frac{\sigma_{T}^{2}}{\sigma_{T}^{2}+\sigma_{e}^{2}}=1-\frac{\sigma_{e}^{2}}{\sigma_{X}^{2}}}
}
}
}
\examples{
\dontrun{
Alldata <- DataGeneration(seed = 1,
                          model_D = rep(1, 10),
                          N=500,
                          nitem_D = 10,
                          latent_dist = "2NM",
                          d = 1.664,
                          sd_ratio = 2,
                          prob = 0.3)

data <- Alldata$data_D

# Analysis

M1 <- IRTest_Dich(data)

reliability(M1)
}
}
\references{
Kim, S., Feldt, L.S. (2010). The estimation of the IRT reliability coefficient and its lower and upper bounds, with comparisons to CTT reliability statistics. \emph{Asia Pacific Education Review, 11}, 179–188.
}
\author{
Seewoo Li \email{cu@yonsei.ac.kr}
}
