% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_chart.R
\name{plot_nested}
\alias{plot_nested}
\title{Plot Nested}
\usage{
plot_nested(
  coord,
  size = 1,
  file_name = "none",
  file_width = 10,
  file_height = 10,
  zoom_x = NULL,
  zoom_y = NULL,
  dpi = 500,
  cor_labels_tests = TRUE,
  cor_labels_facets = TRUE,
  color_global = "black",
  color_nested = "black",
  fade = 85,
  font = "sans",
  size_construct_label = 1,
  size_test_labels = 1,
  size_facet_labels = 1,
  width_axes = 1,
  width_axes_inner = 1,
  width_circles = 1,
  width_circles_inner = 1,
  width_tick = 1,
  width_tick_inner = 1,
  title = NULL,
  size_title = 1,
  size_tick_label = 1,
  size_cor_labels = 1,
  size_cor_labels_inner = 1,
  width_xarrows = 1,
  size_xarrow_heads = 1,
  size_xarrow_labels = 1
)
}
\arguments{
\item{coord}{list generated by \code{\link{coord_nested}}.}

\item{size}{integer; changes the size of most chart objects simultaneously.}

\item{file_name}{character; name of the file to save. Supported formats are:
"pdf" (highest quality and smallest file size), "png", "jpeg"; defaults to
"none".}

\item{file_width}{integer; file width in inches; defaults to 10.}

\item{file_height}{integer; file height in inches; defaults to 10.}

\item{zoom_x}{integer; vector with two values, the edges of the zoomed section
on the x-axis; defaults to NULL.}

\item{zoom_y}{integer; vector with two values, the edges of the zoomed section
on the y-axis; defaults to NULL.}

\item{dpi}{integer; resolution in dots per inch for "png" and "jpeg" files;
defaults to 500.}

\item{cor_labels_tests}{logical; if \code{TRUE}, shows the correlations
between tests as text.}

\item{cor_labels_facets}{logical; if \code{TRUE}, shows the correlations
between facets as text.}

\item{color_global}{global accent color; defaults to "black".}

\item{color_nested}{nested accent color; defaults to "black".}

\item{fade}{integer; brightness of the gray tones between 0 (black) and 100
(white) in steps of 1; defaults to 85.}

\item{font}{character; text font, use extrafonts to access additional fonts;
defaults to "sans", which is "Helvetica".}

\item{size_construct_label}{integer; construct label font size relative to
default.}

\item{size_test_labels}{integer; test label font size relative to default.}

\item{size_facet_labels}{integer; facet label font size relative to default.}

\item{width_axes}{integer; global radial axis width relative to default.}

\item{width_axes_inner}{integer; nested radial axis width relative to default.}

\item{width_circles}{integer; global circle outline width relative to default.}

\item{width_circles_inner}{integer; nested circle outline width relative to
default.}

\item{width_tick}{integer; global axis tick line width relative to default.}

\item{width_tick_inner}{integer; nested axis tick line width relative to
default.}

\item{title}{character; overall chart title; defaults to NULL.}

\item{size_title}{integer; title font size relative to default.}

\item{size_tick_label}{integer; axis tick label font size relative to default.}

\item{size_cor_labels}{integer; font size of the correlations between tests
relative to default.}

\item{size_cor_labels_inner}{integer; font size of the correlations between
facets relative to default.}

\item{width_xarrows}{integer; extra arrow line width relative to default.}

\item{size_xarrow_heads}{integer; extra arrow head length relative to default.}

\item{size_xarrow_labels}{integer; font size of the correlations indicated by
extra arrows relative to default.}
}
\value{
Object of the class "ggplot" and, by default, the same object saved as
 a file.
}
\description{
Generates a nested chart from coordinates.
}
\details{
Use \code{\link{nested_chart}} to create nested charts
}
\seealso{
\code{\link{coord_nested}} \code{\link{nested_chart}}
}
