% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stModel.matrices.R
\name{stModel.matrices}
\alias{stModel.matrices}
\title{Define the spacetime model matrices.}
\usage{
stModel.matrices(smesh, tmesh, model, constr = FALSE)
}
\arguments{
\item{smesh}{a mesh object over the spatial domain.}

\item{tmesh}{a mesh object over the time domain.}

\item{model}{a string identifying the model.
So far we have the following models:
'102', '121', '202' and '220' models.}

\item{constr}{logical to indicate if the integral of the field
over the domain is to be constrained to zero. Default value is FALSE.}
}
\value{
a list containing needed objects for model definition.
\enumerate{
\item 'manifold' to spedify the a string with the model identification
\item a length three vector with the constants \code{c1}, \code{c2} and \code{c3}
\item the vector \code{d}
\item the matrix \code{T}
\item the model matrices \code{M_1}, ..., \code{M_m}
}
}
\description{
This function computes all the matrices needed to build
the precision matrix for spatio-temporal model,
as in Lindgren et. al. (2023)
}
\details{
See the paper for details.
}
