% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_input_tbl.R
\name{check_input_tbl}
\alias{check_input_tbl}
\title{Check class, existing variables and data types of input objects}
\usage{
check_input_tbl(
  x,
  tbl_name,
  parent_func = NULL,
  var_to_check = NULL,
  dt_to_check = NULL
)
}
\arguments{
\item{x}{An output tibble from one of the INDperform modeling or scoring
functions.}

\item{tbl_name}{The name of `x` for the error message.}

\item{parent_func}{The name of the function that generates the output tibble `x`.}

\item{var_to_check}{A character vector listing the variables to check for in `x`.}

\item{dt_to_check}{A character vector listing the data types of each variable
listed in var_to_check (has to be the same order!) to check for.}
}
\value{
The function returns the checked input tibble unchanged.
}
\description{
\code{check_input_tbl} is a helper function for various modeling and
scoring functions in `INDperform`. It checks whether the input object
is of class tibble (should be if an output of one of the required functions)
and if all required variables are included in the tibble with the correct
data type. If not, an error message will be returned.
}
\keyword{internal}
