% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{model_gam_ex}
\alias{model_gam_ex}
\title{Model output tibble from the \code{\link{model_gam}} function}
\format{A data frame with 84 rows and 17 variables:
\describe{
  \item{\code{id}}{Numerical IDs for the IND~press combinations.}
  \item{\code{ind}}{Indicator names.}
  \item{\code{press}}{Pressure names.}
  \item{\code{model_type}}{Specification of the model type; at this stage containing only
             "gam" (Generalized Additive Model).}
  \item{\code{corrstruc}}{Specification of the correlation structure; at this stage
             containing only "none".}
  \item{\code{aic}}{AIC of the fitted models}
  \item{\code{edf}}{Estimated degrees of freedom for the model terms.}
  \item{\code{p_val}}{The p values for the smoothing term (the pressure).}
  \item{\code{signif_code}}{The significance codes for the p-values.}
  \item{\code{r_sq}}{The adjusted r-squared for the models. Defined as the proportion
              of variance explained, where original variance and residual variance are
              both estimated using unbiased estimators. This quantity can be negative
              if your model is worse than a one parameter constant model, and can be
              higher for the smaller of two nested models.}
  \item{\code{expl_dev}}{The proportion of the null deviance explained by the models.}
  \item{\code{nrmse}}{Absolute values of the root mean square error normalized by the
              standard deviation (NRMSE) using no back-transformation.}
  \item{\code{ks_test}}{The p-values from a Kolmogorov-Smirnov Test applied on the model
              residuals to test for normal distribution. P-values > 0.05 indicate
              normally distributed residuals.}
  \item{\code{tac}}{logical; indicates whether temporal autocorrelation (TAC) was detected
              in the residuals. TRUE if model residuals show TAC.}
  \item{\code{pres_outlier}}{A list-column with outliers identified for each model (i.e.
              Cook`s distance > 1). The indices present the position in
              the training data, including NAs.}
  \item{\code{excl_outlier}}{A list-column listing all outliers per model that have been
              excluded in the GAM fitting}
  \item{\code{model}}{A list-column of IND~press-specific gam objects.}
}}
\usage{
model_gam_ex
}
\description{
This is an example output tibble from the \code{model_gam} function applied
on the Central Baltic Sea food web indicator demonstration data.
}
\keyword{datasets}
