% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMIX_cor_twostep.R
\name{IMIX_cor_twostep}
\alias{IMIX_cor_twostep}
\title{IMIX-Cor-Twostep}
\usage{
IMIX_cor_twostep(
  data_input,
  data_type = c("p", "z"),
  g = 8,
  mu_vec,
  cov,
  p,
  tol = 1e-06,
  maxiter = 1000,
  seed = 10,
  verbose = FALSE
)
}
\arguments{
\item{data_input}{An n x d data frame or matrix of the summary statistics z score or p value, n is the nubmer of genes, d is the number of data types. Each row is a gene, each column is a data type.}

\item{data_type}{Whether the input data is the p values or z scores, default is p value}

\item{g}{The number of components, default is 8 for three data types}

\item{mu_vec}{Input of the mean value output from IMIX-Ind result, a list of the mean vectors for each component.}

\item{cov}{A list of initial values for the covariance matrices. If there are three data types and 8 components, then the initial is a list of 8 covariance matrices, each matix is 3*3.}

\item{p}{Initial value for the proportion of the distribution in the Gaussian mixture model}

\item{tol}{The convergence criterion. Convergence is declared when the change in the observed data log-likelihood increases by less than epsilon.}

\item{maxiter}{The maximum number of iteration, default is 1000}

\item{seed}{set.seed, default is 10}

\item{verbose}{Whether to print the full log-likelihood for each iteration, default is FALSE}
}
\value{
A list of the results of IMIX-cor-twostep
\item{posterior prob}{Posterior probability matrix of each gene for each component}
\item{Full LogLik all}{Full log-likelihood of each iteration}
\item{Full MaxLogLik final}{The final log-likelihood of the converged model}
\item{iterations}{Number of iterations run}
\item{pi}{Estimated proportion of each component, sum to 1}
\item{mu}{A list of mean vectors of each component for each data type, this is the prespecified mean}
\item{cov}{A list of estimated variance-covariance matrix of each component}
\item{g}{Number of components}
}
\description{
Fitting a correlated multivariate mixture model with fixed mean from estimated parameters of IMIX-ind. Input of summary statistics z scores or p values of two or three data types.
}
\references{
Ziqiao Wang and Peng Wei. 2020. “IMIX: a multivariate mixture model approach to association analysis through multi-omics data integration.” Bioinformatics. <doi:10.1093/bioinformatics/btaa1001>.
}
