% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_development.R
\name{density_development}
\alias{density_development}
\title{Computes residential and commercial floorspace supply and equilibrium prices.}
\usage{
density_development(Q, K, w, L_j, y_bar, L_i, beta, alpha, mu)
}
\arguments{
\item{Q}{Nx1 array - Floorspaces prices.}

\item{K}{Nx1 array - Land supply.}

\item{w}{NxS - Wages in each location in each sector.}

\item{L_j}{Nx1 matrix - Number of workers in each location.}

\item{y_bar}{\itemize{
\item Average income in each location.
}}

\item{L_i}{Nx1 matrix - Number of residents in each location.}

\item{beta}{Float - Cobb-Douglas parameter output elasticity wrt labor.}

\item{alpha}{Float - Utility parameter that determines preferences for
consumption.}

\item{mu}{Float - Floorspace prod function: output elast wrt capita, 1-mu wrt land.}
}
\description{
Computes residential and commercial floorspace supply and equilibrium prices.
}
