% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{RunJSONIFS2D}
\alias{RunJSONIFS2D}
\title{RunJSONIFS2D}
\usage{
RunJSONIFS2D(JSON, set_palette = 0, filename = "")
}
\arguments{
\item{JSON}{A JSON string, URL or file.}

\item{set_palette}{0 = default palette; 1 = grayscale; 2 = rich.colors.}

\item{filename}{If given, saves the image as a png file in the current working directory.}
}
\value{
A list with a 2D array of pixels and the parameters as a JSON.
}
\description{
This function allows you to plot some fractals using the Iterated Function Systems theory.
}
\examples{
library(IFSPlot)

file_ifs = system.file("extdata", "Fern2D.json", package="IFSPlot")
result = RunJSONIFS2D(file_ifs, 1)
}
