################################################################################
# This file is released under the GNU General Public License,Version 3,GPL-3 #
# Copyright (C) 2020 Yohann Demont                                             #
#                                                                              #
# It is part of IFC package,please cite:                                      #
# -IFC: An R Package for Imaging Flow Cytometry                                #
# -YEAR: 2020                                                                  #
# -COPYRIGHT HOLDERS: Yohann Demont,Gautier Stoll,Guido Kroemer,            #
#                     Jean-Pierre Marolleau,Loïc Garçon,                     #
#                     INSERM,UPD,CHU Amiens                                  #
#                                                                              #
# DISCLAIMER:                                                                  #
# -You are using this package on your own risk!                                #
# -We do not guarantee privacy nor confidentiality.                            #
# -This program is distributed in the hope that it will be useful,but WITHOUT #
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or        #
# FITNESS FOR A PARTICULAR PURPOSE. In no event shall the copyright holders or #
# contributors be liable for any direct,indirect,incidental,special,       #
# exemplary,or consequential damages (including,but not limited to,         #
# procurement of substitute goods or services; loss of use,data,or profits;  #
# or business interruption) however caused and on any theory of liability,    #
# whether in contract,strict liability,or tort (including negligence or      #
# otherwise) arising in any way out of the use of this software,even if       #
# advised of the possibility of such damage.                                   #
#                                                                              #
# You should have received a copy of the GNU General Public License            #
# along with IFC. If not,see <http://www.gnu.org/licenses/>.                  #
################################################################################

#' @title Text to Image Conversion
#' @description
#' Converts string to matrix of 0 and 1.
#' @param text a character string.
#' @details at symbol @@ is a special character used for scale
#' @keywords internal
texttomatrix <- function(text = NULL) {
  text = as.character(text)
  if(length(text)==0) {
    text = "blank"
  } else {
    text = unlist(strsplit(text,split ="",fixed = TRUE),recursive = FALSE,use.names = FALSE)
  }
  spacer = rbind(0,0,0,0,0,0,0,deparse.level=0)
  rbind(0,do.call(cbind,c(lapply(text,FUN = function(x) {
  cbind(deparse.level = 0,spacer,matrix(nrow = 7,byrow = TRUE,
  data = {
    switch(EXPR = x,
           "NA" =c(1,0,0,1,0,0,1,1,0,
                   1,0,0,1,0,1,0,0,1,
                   1,1,0,1,0,1,0,0,1,
                   1,1,1,1,0,1,1,1,1,
                   1,0,1,1,0,1,0,0,1,
                   1,0,0,1,1,1,0,0,1,
                   1,0,0,1,1,1,0,0,1),
           "1"=c(0,0,1,
                 0,1,1,
                 1,0,1,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 0,0,1),
           "2"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 0,0,0,0,1,
                 0,0,0,1,0,
                 0,0,1,0,0,
                 0,1,0,0,0,
                 1,1,1,1,1),
           "3"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 0,0,0,0,1,
                 0,0,0,1,0,
                 0,0,0,0,1,
                 1,0,0,0,1,
                 0,1,1,1,0),
           "4"=c(0,0,0,1,0,
                 0,0,1,1,0,
                 0,1,0,1,0,
                 1,0,0,1,0,
                 1,1,1,1,1,
                 0,0,0,1,0,
                 0,0,0,1,0),
           "5"=c(1,1,1,1,0,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,1,1,1,0,
                 0,0,0,0,1,
                 0,0,0,0,1,
                 1,1,1,1,0),
           "6"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,0,
                 1,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,1,1,0),
           "7"=c(1,1,1,1,1,
                 0,0,0,0,1,
                 0,0,0,0,1,
                 0,0,0,1,0,
                 0,0,1,0,0,
                 0,0,1,0,0,
                 0,0,1,0,0),
           "8"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,1,1,0),
           "9"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,1,1,1,
                 0,0,0,0,1,
                 1,0,0,0,1,
                 0,1,1,1,0),
           "0"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,1,1,0),
           "A"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,1,1,1,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1),
           "B"=c(1,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,1,1,1,0),
           "C"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,0,0,0,1,
                 0,1,1,1,0),
           "D"=c(1,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,1,1,1,0),
           "E"=c(1,1,1,1,1,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,1,1,1,0,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,1,1,1,1),
           "F"=c(1,1,1,1,1,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,1,1,1,0,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,0,0,0,0),
           "G"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,0,0,1,1,
                 1,0,0,0,1,
                 0,1,1,1,0),
           "H"=c(1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,1,1,1,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1),
           "I"=c(1,1,1,1,1,
                 0,0,1,0,0,
                 0,0,1,0,0,
                 0,0,1,0,0,
                 0,0,1,0,0,
                 0,0,1,0,0,
                 1,1,1,1,1),
           "J"=c(0,0,0,0,1,
                 0,0,0,0,1,
                 0,0,0,0,1,
                 0,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,1,1,0),
           "K"=c(1,0,0,0,1,
                 1,0,0,1,0,
                 1,0,1,0,0,
                 1,1,0,0,0,
                 1,0,1,0,0,
                 1,0,0,1,0,
                 1,0,0,0,1),
           "L"=c(1,0,0,0,0,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,0,0,0,0,
                 1,1,1,1,1),
           "M"=c(1,0,0,0,1,
                 1,1,0,1,1,
                 1,0,1,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1),
           "N"=c(1,0,0,0,1,
                 1,0,0,0,1,
                 1,1,0,0,1,
                 1,0,1,0,1,
                 1,0,0,1,1,
                 1,0,0,0,1,
                 1,0,0,0,1),
           "O"=c(1,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,1,1,0),
           "P"=c(1,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,1,1,1,0,
                 1,0,0,0,0,
                 1,0,0,0,0),
           "Q"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,1,0,1,
                 1,0,0,1,1,
                 0,1,1,1,1),
           "R"=c(1,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1),
           "S"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 1,0,0,0,0,
                 0,1,1,1,0,
                 0,0,0,0,1,
                 1,0,0,0,1,
                 0,1,1,1,0),
           "T"=c(1,1,1,1,1,
                 0,0,1,0,0,
                 0,0,1,0,0,
                 0,0,1,0,0,
                 0,0,1,0,0,
                 0,0,1,0,0,
                 0,0,1,0,0),
           "U"=c(1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,1,1,0),
           "V"=c(1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,0,1,0,
                 0,0,1,0,0),
           "W"=c(1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,1,0,1,
                 1,1,0,1,1,
                 1,0,0,0,1),
           "X"=c(1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,0,1,0,
                 0,0,1,0,0,
                 0,1,0,1,0,
                 1,0,0,0,1,
                 1,0,0,0,1),
           "Y"=c(1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,0,1,0,
                 0,0,1,0,0,
                 0,0,1,0,0,
                 0,0,1,0,0),
           "Z"=c(1,1,1,1,1,
                 0,0,0,0,1,
                 0,0,0,1,0,
                 0,0,1,0,0,
                 0,1,0,0,0,
                 1,0,0,0,0,
                 1,1,1,1,1),
           "a"=c(0,0,0,0,0,
                 0,0,0,0,0,
                 0,1,1,0,0,
                 0,0,0,1,0,
                 0,1,1,1,0,
                 1,0,0,1,0,
                 0,1,1,0,1),
           "b"=c(0,0,0,0,
                 1,0,0,0,
                 1,0,0,0,
                 1,1,1,0,
                 1,0,0,1,
                 1,0,0,1,
                 1,1,1,0),
           "c"=c(0,0,0,0,
                 0,0,0,0,
                 0,1,1,0,
                 1,0,0,1,
                 1,0,0,0,
                 1,0,0,1,
                 0,1,1,0),
           "d"=c(0,0,0,0,
                 0,0,0,1,
                 0,0,0,1,
                 0,1,1,1,
                 1,0,0,1,
                 1,0,0,1,
                 0,1,1,1),
           "e"=c(0,0,0,0,
                 0,0,0,0,
                 0,1,1,0,
                 1,0,0,1,
                 1,1,1,1,
                 1,0,0,0,
                 0,1,1,1),
           "f"=c(0,0,1,1,
                 0,1,0,0,
                 1,1,1,1,
                 0,1,0,0,
                 0,1,0,0,
                 0,1,0,0,
                 0,1,0,0),
           "g"=c(0,0,0,0,
                 0,1,1,1,
                 1,0,0,1,
                 1,0,0,1,
                 1,1,1,1,
                 0,0,0,1,
                 1,1,1,0),
           "h"=c(1,0,0,0,
                 1,0,0,0,
                 1,0,0,0,
                 1,1,1,1,
                 1,0,0,1,
                 1,0,0,1,
                 1,0,0,1),
           "i"=c(0,0,1,
                 0,0,0,
                 1,1,1,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 0,0,1),
           "j"=c(0,0,1,
                 0,0,0,
                 1,1,1,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 1,1,0),
           "k"=c(0,0,0,0,
                 1,0,0,0,
                 1,0,0,1,
                 1,0,0,1,
                 1,1,1,0,
                 1,0,0,1,
                 1,0,0,1),
           "l"=c(1,1,1,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 0,0,1),
           "m"=c(0,0,0,0,0,
                 0,0,0,0,0,
                 1,1,1,1,0,
                 1,0,1,0,1,
                 1,0,1,0,1,
                 1,0,1,0,1,
                 1,0,1,0,1),
           "n"=c(0,0,0,0,
                 0,0,0,0,
                 1,1,1,0,
                 1,0,0,1,
                 1,0,0,1,
                 1,0,0,1,
                 1,0,0,1),
           "o"=c(0,0,0,0,
                 0,0,0,0,
                 0,1,1,0,
                 1,0,0,1,
                 1,0,0,1,
                 1,0,0,1,
                 0,1,1,0),
           "p"=c(0,0,0,0,
                 1,1,1,0,
                 1,0,0,1,
                 1,0,0,1,
                 1,1,1,0,
                 1,0,0,0,
                 1,0,0,0),
           "q"=c(0,0,0,0,
                 0,1,1,1,
                 1,0,0,1,
                 1,0,0,1,
                 0,1,1,1,
                 0,0,0,1,
                 0,0,0,1),
           "r"=c(0,0,0,0,
                 0,0,0,0,
                 0,1,1,0,
                 1,0,0,1,
                 1,0,0,0,
                 1,0,0,0,
                 1,0,0,0),
           "s"=c(0,0,0,0,
                 0,0,0,0,
                 0,1,1,1,
                 1,0,0,0,
                 0,1,1,0,
                 0,0,0,1,
                 1,1,1,0),
           "t"=c(0,0,0,0,
                 0,1,0,0,
                 1,1,1,1,
                 0,1,0,0,
                 0,1,0,0,
                 0,1,0,0,
                 0,0,1,1),
           "u"=c(0,0,0,0,
                 0,0,0,0,
                 1,0,0,1,
                 1,0,0,1,
                 1,0,0,1,
                 1,0,0,1,
                 0,1,1,1),
           "v"=c(0,0,0,0,0,
                 0,0,0,0,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 0,1,0,1,0,
                 0,0,1,0,0),
           "w"=c(0,0,0,0,0,
                 0,0,0,0,0,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,1,0,1,
                 0,1,0,1,0),
           "x"=c(0,0,0,0,
                 0,0,0,0,
                 1,0,0,1,
                 1,0,0,1,
                 0,1,1,0,
                 1,0,0,1,
                 1,0,0,1),
           "y"=c(0,0,0,0,
                 0,0,0,0,
                 1,0,0,1,
                 1,0,0,1,
                 0,1,1,1,
                 0,0,0,1,
                 1,1,1,0),
           "z"=c(0,0,0,0,
                 0,0,0,0,
                 1,1,1,1,
                 0,0,1,0,
                 0,1,0,0,
                 1,0,0,0,
                 1,1,1,1),
           "+"=c(0,0,0,
                 0,0,0,
                 0,1,0,
                 1,1,1,
                 0,1,0,
                 0,0,0,
                 0,0,0),
           "-"=c(0,0,0,
                 0,0,0,
                 0,0,0,
                 1,1,1,
                 0,0,0,
                 0,0,0,
                 0,0,0),
           "_"=c(0,0,0,0,0,
                 0,0,0,0,0,
                 0,0,0,0,0,
                 0,0,0,0,0,
                 0,0,0,0,0,
                 0,0,0,0,0,
                 1,1,1,1,1),
           "*"=c(0,0,0,
                 0,0,0,
                 1,0,1,
                 0,1,0,
                 1,0,1,
                 0,0,0,
                 0,0,0),
           "/"=c(0,0,0,
                 0,0,0,
                 0,0,1,
                 0,1,0,
                 1,0,0,
                 0,0,0,
                 0,0,0),
           "%"=c(0,0,0,0,0,
                 1,1,0,0,1,
                 1,1,0,1,0,
                 0,0,1,0,0,
                 0,1,0,1,1,
                 1,0,0,1,1,
                 0,0,0,0,0),
           "&"=c(0,0,0,0,0,
                 0,1,0,0,0,
                 1,0,1,0,0,
                 0,1,0,0,1,
                 1,0,1,1,0,
                 1,0,0,1,0,
                 0,1,1,0,1),
           "="=c(0,0,0,0,
                 0,0,0,0,
                 1,1,1,1,
                 0,0,0,0,
                 1,1,1,1,
                 0,0,0,0,
                 0,0,0,0),
           "?"=c(0,1,1,1,0,
                 1,0,0,0,1,
                 0,0,0,1,0,
                 0,0,1,0,0,
                 0,0,1,0,0,
                 0,0,0,0,0,
                 0,0,1,0,0),
           "!"=c(1,
                 1,
                 1,
                 1,
                 1,
                 0,
                 1),
           "."=c(0,0,
                 0,0,
                 0,0,
                 0,0,
                 1,1,
                 1,1,
                 0,0),
           ":"=c(0,0,
                 1,1,
                 1,1,
                 0,0,
                 1,1,
                 1,1,
                 0,0),
           ";"=c(0,0,0,
                 0,1,1,
                 0,1,1,
                 0,0,0,
                 0,1,1,
                 0,0,1,
                 0,1,0),
           "`"=c(1,0,
                 0,1,
                 0,0,
                 0,0,
                 0,0,
                 0,0,
                 0,0),
           ","=c(0,0,
                 0,0,
                 0,0,
                 0,0,
                 1,1,
                 0,1,
                 1,0),
           ">"=c(1,0,0,0,
                 0,1,0,0,
                 0,0,1,0,
                 0,0,0,1,
                 0,0,1,0,
                 0,1,0,0,
                 1,0,0,0),
           "<"=c(0,0,0,1,
                 0,0,1,0,
                 0,1,0,0,
                 1,0,0,0,
                 0,1,0,0,
                 0,0,1,0,
                 0,0,0,1),
           "^"=c(0,1,0,
                 1,0,1,
                 0,0,0,
                 0,0,0,
                 0,0,0,
                 0,0,0,
                 0,0,0),
           "~"=c(0,0,0,0,0,
                 0,0,0,0,0,
                 0,1,0,0,0,
                 1,0,1,0,1,
                 0,0,0,1,0,
                 0,0,0,0,0,
                 0,0,0,0,0),
           "#"=c(0,0,0,0,0,
                 0,1,0,1,0,
                 1,1,1,1,1,
                 0,1,0,1,0,
                 1,1,1,1,1,
                 0,1,0,1,0,
                 0,0,0,0,0),
           "("=c(0,1,0,
                 1,0,0,
                 1,0,0,
                 1,0,0,
                 1,0,0,
                 1,0,0,
                 0,1,0),
           ")"=c(0,1,0,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 0,1,0),
           "["=c(1,1,1,
                 1,0,0,
                 1,0,0,
                 1,0,0,
                 1,0,0,
                 1,0,0,
                 1,1,1),
           "]"=c(1,1,1,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 0,0,1,
                 1,1,1),
           "{"=c(0,0,1,
                 0,1,0,
                 0,1,0,
                 1,1,0,
                 0,1,0,
                 0,1,0,
                 0,0,1),
           "}"=c(1,0,0,
                 0,1,0,
                 0,1,0,
                 0,1,1,
                 0,1,0,
                 0,1,0,
                 1,0,0),
           "$"=c(0,0,1,0,0,
                 0,1,1,1,1,
                 1,0,1,0,0,
                 0,1,1,1,0,
                 0,0,1,0,1,
                 1,1,1,1,0,
                 0,0,1,0,0),
           # non ASCII characters
           # "euro"=c(0,0,1,1,1,0,
           #                     0,1,0,0,0,1,
           #                     1,1,1,1,0,0,
           #                     0,1,0,0,0,0,
           #                     1,1,1,1,0,0,
           #                     0,1,0,0,0,1,
           #                     0,0,1,1,1,0),
           # "pound"=c(0,0,1,1,
           #                     0,1,0,0,
           #                     0,1,0,0,
           #                     1,1,1,1,
           #                     0,1,0,0,
           #                     0,1,0,0,
           #                     1,1,1,1),
           "@"=c(0,0,1,1,1,0,0,0,
                 0,1,0,0,0,1,0,0,
                 1,0,0,1,1,0,1,0,
                 1,0,1,0,1,0,1,0,
                 1,0,1,1,1,0,1,0,
                 1,0,0,0,0,0,0,1,
                 0,1,1,1,1,1,0,0),
           # | is used to have greek symbol mu for scale
           "|"=c(1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,0,1,
                 1,0,0,1,1,
                 1,1,1,0,1,
                 1,0,0,0,0,
                 1,0,0,0,0),
           " "=c(0,0,0,
                 0,0,0,
                 0,0,0,
                 0,0,0,
                 0,0,0,
                 0,0,0,
                 0,0,0),
           '"'=c(1,0,1,
                 1,0,1,
                 0,0,0,
                 0,0,0,
                 0,0,0,
                 0,0,0,
                 0,0,0),
           "'"=c(1,
                 1,
                 0,
                 0,
                 0,
                 0,
                 0),
           "blank"=c(0,
                     0,
                     0,
                     0,
                     0,
                     0,
                     0),
           {# unknown character
             c(1,1,1,
               1,0,1,
               1,0,1,
               1,0,1,
               1,0,1,
               1,0,1,
               1,1,1)})
  }))
  }),0,deparse.level = 0)),0,deparse.level = 0)
}
