% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readIFC.R
\name{readIFC}
\alias{readIFC}
\title{IFC Files Generic Reader}
\usage{
readIFC(fileName, ...)
}
\arguments{
\item{fileName}{path to file.}

\item{...}{arguments to pass to \code{\link{ExtractFromDAF}} or \code{\link{ExtractFromXIF}} or \code{\link{ExtractFromFCS}}.}
}
\value{
an object of class `IFC_data`.
}
\description{
Reads IFC data from IFC files no matter if they are FCS, DAF, RIF or CIF.
}
\details{
If input 'fileName' is a DAF file \code{\link{ExtractFromDAF}} will be used to read the file.\cr
If it is a CIF or RIF file \code{\link{readIFC}} will use \code{\link{ExtractFromXIF}}.\cr
Finally, if 'fileName' is not a DAF, nor a CIF, nor a RIF file \code{\link{readIFC}} will use \code{\link{ExtractFromFCS}}.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a rif file, but you can also read daf or cif
  file_rif <- system.file("extdata", "example.rif", package = "IFCdata")
  rif <- readIFC(fileName = file_rif)
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
