% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_add_features.R
\name{data_add_features}
\alias{data_add_features}
\title{Add Feature to IFC_data Object}
\usage{
data_add_features(obj, features, ...)
}
\arguments{
\item{obj}{an `IFC_data` object extracted by ExtractFromDAF(extract_features = TRUE) or ExtractFromXIF(extract_features = TRUE).}

\item{features}{a list of features to add to obj. Each element of this list will be coerced by \code{\link{buildFeature}}.}

\item{...}{Other arguments to be passed.}
}
\value{
an IFC_data object with features added.
}
\description{
Adds features to an already existing `IFC_data` object.
}
\details{
A warning will be thrown if a provided feature is already existing in obj.\cr
In such a case this feature will not be added to obj.\cr
If any input feature is not well defined and can't be created then an error will occur.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a daf file
  file_daf <- system.file("extdata", "example.daf", package = "IFCdata")
  daf <- ExtractFromDAF(fileName = file_daf)
  ## copy 1st feature found in daf
  feat_def <- daf$features_def[[1]]
  if(length(feat_def) != 0) {
    feat_def_copy <- feat_def
    ## modify name and value of copied features
    feat_def_copy$name <- "copied_feature"
    feat <- daf$features[, feat_def$name]
    feat_copy <- feat
    feat_copy <- feat_copy * 10
    ## create new object with this new feature
    dafnew <- data_add_features(obj = daf, features = list(c(feat_def_copy, list(val = feat_copy))))
  }
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
