UFA_workflow <- function(spreadsheet) {
  ##
  on.exit({
    sillyErrors <- c("",
                     "StopIteration", # StopIteration is generated by `foreach`
                     "cannot shut down device 1 (the null device)") # error by `dev.off()`
    ##
    errorMessages <- geterrmessage()
    xSillyErrors <- which((errorMessages %in% sillyErrors) == FALSE)
    if (length(xSillyErrors) > 0) {
      IPA_logRecorder(errorMessages[xSillyErrors])
      IPA_logRecorder("Stopped IDSL.UFA workflow!")
    }
    ##
    if (!is.null(warnings())) {
      IPA_logRecorder(warnings())
    }
    ##
    if (exists('logIPA')) {
      rm(logIPA, envir = .GlobalEnv)
    }
  })
  ##
  gc()
  closeAllConnections()
  ##############################################################################
  spreadsheet <- gsub("\\", "/", spreadsheet, fixed = TRUE)
  PARAM <- UFA_xlsxAnalyzer(spreadsheet)
  if (!is.null(PARAM)) {
    ############################################################################
    x0001 <- PARAM[which(PARAM[, 1] == 'PARAM0001'), 2]
    if (tolower(x0001) == "yes") {
      x0002 <- PARAM[which(PARAM[, 1] == 'PARAM0002'), 2]
      if (tolower(x0002) == "yes") {
        PARAM_MF <- readxl::read_xlsx(spreadsheet, sheet = "enumerated_chemical_space")
        UFA_enumerated_chemical_space(PARAM_MF)
      }
      ##
      x0003 <- PARAM[which(PARAM[, 1] == 'PARAM0003'), 2]
      if (tolower(x0003) == "yes") {
        PARAM_SF <- readxl::read_xlsx(spreadsheet, sheet = "formula_source")
        PARAM_SF <- cbind(PARAM_SF[, 2], PARAM_SF[, 4])
        molecular_formulas_source_IPDB(PARAM_SF)
      }
    }
    ##
    x0005 <- tolower(PARAM[which(PARAM[, 1] == 'PARAM0005'), 2])
    x0006 <- tolower(PARAM[which(PARAM[, 1] == 'PARAM0006'), 2])
    ##
    if ((x0005 == "yes") | (x0006 == "yes")) {
      ##
      ##########################################################################
      ## To create log record for IDSL.UFA
      initiation_time_UFA <- Sys.time()
      timeZone <- tryCatch(Sys.timezone(), warning = function(w) {"UTC"}, error = function(e) {"UTC"})
      input_path_hrms <- PARAM[which(PARAM[, 1] == 'PARAM0010'), 2]
      output_path <- PARAM[which(PARAM[, 1] == 'PARAM0014'), 2]
      .GlobalEnv$logIPA <- paste0(output_path, "/logUFA_performance.txt")
      IPA_logRecorder(paste0(rep("", 100), collapse = "="))
      IPA_logRecorder(paste0("mzML/mzXML/netCDF:  ", input_path_hrms))
      IPA_logRecorder(paste0("OUTPUT:  ", output_path))
      IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
      IPA_logRecorder("Initiated IDSL.UFA workflow!")
      IPA_logRecorder(paste0(as.character(initiation_time_UFA), " ", timeZone))
      IPA_logRecorder("", printMessage = FALSE)
      IPA_logRecorder("", printMessage = FALSE)
      IPA_logRecorder(paste0(PARAM[, 1], "\t", PARAM[, 2]),  printMessage = FALSE)
      IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
      ##
      ##########################################################################
      ##
    }
    ##
    if (tolower(x0005) == "yes") {
      ##########################################################################
      address_IPDB <- PARAM[which(PARAM[, 1] == "PARAM0004"), 2]
      IPA_logRecorder(paste0("Loading the Isotopic Profiles DataBase (IPDB) from `", address_IPDB, "`!"))
      IPDB <- IDSL.IPA::loadRdata(address_IPDB)
      ## Temp
      if (length(IPDB) != 8) {
        stop(IPA_logRecorder("The selected IPDB is not consistent with this version of IDSL.UFA!"))
      }
      ##
      NPT <- as.numeric(PARAM[which(PARAM[, 1] == "PARAM0009"), 2])
      ##
      if (tolower(PARAM[which(PARAM[, 1] == 'PARAM0011'), 2]) == "all") {
        file_name_hrms <- dir(path = input_path_hrms)
        file_name_hrms <- file_name_hrms[grep(paste0(".", tolower(PARAM[which(PARAM[, 1] == 'PARAM0012'), 2]), "$"), file_name_hrms, ignore.case = TRUE)]
      } else {
        samples_string <- PARAM[which(PARAM[, 1] == 'PARAM0011'), 2]
        file_name_hrms <- strsplit(samples_string, ";")[[1]]
      }
      ##
      L_HRMS <- length(file_name_hrms)
      if (L_HRMS == 0) {
        stop(IPA_logRecorder("EMPTY HRMS FOLDER!!!"))
      }
      ##
      input_path_pl <- PARAM[which(PARAM[, 1] == 'PARAM0013'), 2]
      file_names_peaklist1 <- dir(path = input_path_pl, pattern = ".Rdata")
      file_names_peaklist2 <- dir(path = input_path_pl, pattern = "peaklist_")
      file_names_peaklist <- file_names_peaklist1[file_names_peaklist1 %in% file_names_peaklist2]
      #
      file_names_peaklist_hrms1 <- gsub(".Rdata", "", file_names_peaklist)
      file_names_peaklist_hrms2 <- gsub("peaklist_", "", file_names_peaklist_hrms1)
      file_names_peaklist_hrms <- file_name_hrms %in% file_names_peaklist_hrms2
      L_PL <- length(which(file_names_peaklist_hrms == TRUE))
      if (L_HRMS != L_PL) {
        stop(IPA_logRecorder("Error!!! peaklist files are not available for the entire selected HRMS files!"))
      }
      ##
      output_path_annotated_mf_tables <- paste0(output_path, "/annotated_mf_tables")
      if (!dir.exists(output_path_annotated_mf_tables)) {
        dir.create(output_path_annotated_mf_tables, recursive = TRUE)
      }
      opendir(output_path_annotated_mf_tables)
      ##
      para_mode <- PARAM[which(PARAM[, 1] == 'PARAM0015'), 2]
      mass_accuracy <- as.numeric(PARAM[which(PARAM[, 1] == "PARAM0016"), 2])
      maxNEME <- as.numeric(PARAM[which(PARAM[, 1] == "PARAM0017"), 2])
      minPCS <- as.numeric(PARAM[which(PARAM[, 1] == "PARAM0018"), 2])
      minNDCS <- as.numeric(PARAM[which(PARAM[, 1] == "PARAM0019"), 2])
      minRCS <- as.numeric(PARAM[which(PARAM[, 1] == "PARAM0020"), 2])
      Score_coeff <- tryCatch(eval(parse(text = PARAM[which(PARAM[, 1] == 'PARAM0021'), 2])), error = function(e){rep(1, 5)})
      ##
      MF_library_search_TRUE <- FALSE
      x0022 <- PARAM[which(PARAM[, 1] == 'PARAM0022'), 2]
      if (tolower(x0022) == "yes") {
        MF_library_search_TRUE <- TRUE
        IonPathways <- tryCatch(eval(parse(text = PARAM[which(PARAM[, 1] == 'PARAM0023'), 2])), error = function(e){c("[M]")})
        ##
        x0024 <- PARAM[which(PARAM[, 1] == 'PARAM0024'), 2]
        MF_library <- IDSL.IPA::loadRdata(x0024)
      }
      ##
      IPA_logRecorder("Initiated molecular formula annotation on individual peaklists!")
      IPA_logRecorder("Individual annotated peaklists tables are stored in `.Rdata` and `.csv` formats in the `annotated_mf_tables` folder!")
      ##
      call_molecular_formula_annotation <- function(i) {
        peaklist <- IDSL.IPA::loadRdata(paste0(input_path_pl, "/peaklist_", file_name_hrms[i], ".Rdata"))
        ##
        outputer <- IDSL.IPA::IPA_MSdeconvoluter(input_path_hrms, file_name_hrms[i])
        spectraList <- outputer[["spectraList"]]
        ##
        MolecularFormulaAnnotationTable <- molecular_formula_annotator(IPDB, spectraList, peaklist, mass_accuracy, maxNEME, minPCS, minNDCS, minRCS, Score_coeff, number_processing_threads = NPT)
        ##
        if (MF_library_search_TRUE) {
          MolecularFormulaAnnotationTable <- molecular_formula_library_search(MolecularFormulaAnnotationTable, IPDB, MF_library, IonPathways, number_processing_threads = NPT)
        }
        ##
        save(MolecularFormulaAnnotationTable, file = paste0(output_path_annotated_mf_tables, "/MolecularFormulaAnnotationTable_", file_name_hrms[i], ".Rdata"))
        write.csv(MolecularFormulaAnnotationTable, file = paste0(output_path_annotated_mf_tables, "/MolecularFormulaAnnotationTable_", file_name_hrms[i], ".csv"), row.names = FALSE)
        ##
        return()
      }
      if (para_mode == "peakmode" | NPT == 1) {
        progressBARboundaries <- txtProgressBar(min = 0, max = L_PL, initial = 0, style = 3)
        for (i in 1:L_PL) {
          setTxtProgressBar(progressBARboundaries, i)
          ##
          call_molecular_formula_annotation(i)
        }
        close(progressBARboundaries)
      } else if (para_mode == "samplemode") {
        NPT0 <- NPT
        NPT <- 1
        ##
        osType <- Sys.info()[['sysname']]
        ##
        if (osType == "Linux") {
          ##
          null_variable <- mclapply(1:L_PL, function (k) {
            call_molecular_formula_annotation(k)
          }, mc.cores = NPT0)
          ##
          closeAllConnections()
          ##
        } else if (osType == "Windows") {
          ##
          clust <- makeCluster(NPT0)
          registerDoParallel(clust)
          ##
          null_variable <- foreach(k = 1:L_PL, .verbose = FALSE) %dopar% {
            call_molecular_formula_annotation(k)
          }
          ##
          stopCluster(clust)
          ##
        }
      }
      IPA_logRecorder("Sucessfully completed molecular formula annotation on individual peaklists!")
      IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
      ##
      gc()
      closeAllConnections()
    }
    ############################################################################
    if (tolower(x0006) == "yes") {
      aligned_molecular_formula_annotator(PARAM)
    }
    ##
    ############################################################################
    ##
    if ((x0005 == "yes") | (x0006 == "yes")) {
      completion_time_UFA <- Sys.time()
      IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
      required_time <- completion_time_UFA - initiation_time_UFA
      print(required_time)
      IPA_logRecorder(paste0(as.character(completion_time_UFA), " ", timeZone), printMessage = FALSE)
      IPA_logRecorder("", printMessage = FALSE)
      IPA_logRecorder("", printMessage = FALSE)
      IPA_logRecorder("Completed IDSL.UFA workflow!")
      IPA_logRecorder(paste0(rep("", 100), collapse = "="), printMessage = FALSE)
    }
    ##
    ############################################################################
    ##
    x0007 <- PARAM[which(PARAM[, 1] == 'PARAM0007'), 2]
    if (tolower(x0007) == "yes") {
      UFA_score_coefficient_workflow(spreadsheet)
    }
    ############################################################################
    x0008 <- PARAM[which(PARAM[, 1] == 'PARAM0008'), 2]
    if (tolower(x0008) == "yes") {
      PARAM_SA <- UFA_profile_visualizer_xlsxAnalyzer(spreadsheet)
      ##
      ##########################################################################
      ## To create log record for IDSL.UFA
      initiation_time_SA <- Sys.time()
      timeZone <- tryCatch(Sys.timezone(), warning = function(w) {"UTC"}, error = function(e) {"UTC"})
      input_path <- PARAM_SA[which(PARAM_SA[, 1] == 'PARAM0010'), 2]
      output_path <- PARAM_SA[which(PARAM_SA[, 1] == 'PARAM0014'), 2]
      .GlobalEnv$logIPA <- paste0(output_path, "/logUFA_profile_visualization.txt")
      IPA_logRecorder(paste0(rep("", 100), collapse = "="))
      IPA_logRecorder(paste0("mzML/mzXML/netCDF:  ", input_path))
      IPA_logRecorder(paste0("OUTPUT:  ", output_path))
      IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
      IPA_logRecorder("Initiated producing mass spectra!")
      IPA_logRecorder(paste0(as.character(initiation_time_SA), " ", timeZone))
      IPA_logRecorder("", printMessage = FALSE)
      IPA_logRecorder("", printMessage = FALSE)
      IPA_logRecorder(paste0(PARAM_SA[, 1], "\t", PARAM_SA[, 2]),  printMessage = FALSE)
      IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
      ##
      ##########################################################################
      ##
      AnnotatedSpectraTable <- UFA_profile_visualizer(PARAM_SA)
      ##
      exportedAnnotatedSpectraTable <- ifelse((tolower(PARAM_SA[which(PARAM_SA[, 1] == 'SA0011'), 2]) == "yes"), TRUE, FALSE)
      if (exportedAnnotatedSpectraTable) {
        save(AnnotatedSpectraTable, file = paste0(output_path, "/AnnotatedSpectraTable.Rdata"))
        write.csv(AnnotatedSpectraTable, file = paste0(output_path, "/AnnotatedSpectraTable.csv"), row.names = FALSE)
        IPA_logRecorder(paste0("The AnnotatedSpectraTable stored in `.Rdata` and `.csv` formats in the `", output_path,"` folder!"))
      }
      ##
      ##########################################################################
      ##
      completion_time_SA <- Sys.time()
      IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
      required_time <- completion_time_SA - initiation_time_SA
      print(required_time)
      IPA_logRecorder(paste0(as.character(completion_time_SA), " ", timeZone), printMessage = FALSE)
      IPA_logRecorder("", printMessage = FALSE)
      IPA_logRecorder("", printMessage = FALSE)
      IPA_logRecorder("Completed producing comparison spectra!")
      IPA_logRecorder(paste0(rep("", 100), collapse = "="), printMessage = FALSE)
      ##
      ##########################################################################
      ##
    }
  }
}
