DDA_xlsxAnalyzer <- function(spreadsheet) {
  ##
  checkpoint_parameter <- FALSE
  ##
  if (typeof(spreadsheet) == "list") {
    if (ncol(spreadsheet) >= 4) {
      PARAM_DDA <- cbind(spreadsheet[, 2], spreadsheet[, 4])
      checkpoint_parameter <- TRUE
      ##
    } else if (ncol(spreadsheet) == 2) {
      PARAM_DDA <- spreadsheet
      checkpoint_parameter <- TRUE
      ##
    } else {
      FSA_message("The DDA spreadsheet tab was not produced properly!")
    }
  } else if (typeof(spreadsheet) == "character") {
    if (length(spreadsheet) == 1) {
      if (file.exists(spreadsheet)) {
        PARAM_DDA <- readxl::read_xlsx(spreadsheet, sheet = "DDA")
        PARAM_DDA <- cbind(PARAM_DDA[, 2], PARAM_DDA[, 4])
        checkpoint_parameter <- TRUE
      } else {
        FSA_message("The DDA spreadsheet tab not found! It should be an Excel file with .xlsx extention!")
      }
    } else {
      FSA_message("The DDA spreadsheet tab was not produced properly!")
    }
  } else {
    FSA_message("The DDA spreadsheet tab was not produced properly!")
  }
  ##############################################################################
  if (checkpoint_parameter) {
    ##
    xDDAmode <- which(PARAM_DDA[, 1] == 'DDA0000')
    if (length(xDDAmode) > 0) {
      DDA_Analysis_Mode <- PARAM_DDA[xDDAmode, 2]
      if (is.na(DDA_Analysis_Mode)) {
        FSA_message("ERROR!!! Problem with DDA0000!")
        checkpoint_parameter <- FALSE
      } else {
        DDA_Analysis_Mode <- gsub(" ", "", tolower(DDA_Analysis_Mode))
        if (DDA_Analysis_Mode == "rawddaspectra" | DDA_Analysis_Mode == "idsl.ipa") {
          PARAM_DDA[xDDAmode, 2] <- DDA_Analysis_Mode
        } else {
          FSA_message("ERROR!!! Problem with DDA0000!")
          checkpoint_parameter <- FALSE
        }
      }
    } else {
      DDA_Analysis_Mode <- "idsl.ipa"
    }
    ##
    x0001 <- which(PARAM_DDA[, 1] == 'DDA0001')
    DDA0001 <- PARAM_DDA[x0001, 2]
    if (is.na(DDA0001)) {
      FSA_message("ERROR!!! Problem with DDA0001!")
      checkpoint_parameter <- FALSE
    } else {
      DDA0001 <- gsub(" ", "", tolower(DDA0001))
      if (DDA0001 == "yes" | DDA0001 == "no") {
        PARAM_DDA[x0001, 2] <- DDA0001
      } else {
        FSA_message("ERROR!!! Problem with DDA0001!")
        checkpoint_parameter <- FALSE
      }
    }
    ##
    x0002 <- which(PARAM_DDA[, 1] == 'DDA0002')
    DDA0002 <- PARAM_DDA[x0002, 2]
    if (is.na(DDA0002)) {
      FSA_message("ERROR!!! Problem with DDA0002!")
      checkpoint_parameter <- FALSE
    } else {
      DDA0002 <- gsub(" ", "", tolower(DDA0002))
      if (DDA0002 == "yes" | DDA0002 == "no") {
        PARAM_DDA[x0002, 2] <- DDA0002
      } else {
        FSA_message("ERROR!!! Problem with DDA0002!")
        checkpoint_parameter <- FALSE
      }
    }
    ##
    number_processing_threads <- as.numeric(PARAM_DDA[which(PARAM_DDA[, 1] == 'DDA0003'), 2])
    if (length(number_processing_threads) == 0) {
      FSA_message("ERROR!!! Problem with DDA0003! This parameter should be a positive integer!")
      checkpoint_parameter <- FALSE
    } else {
      if (number_processing_threads >= 1) {
        if ((number_processing_threads %% 1) != 0) {
          FSA_message("ERROR!!! Problem with DDA0003! This parameter should be a positive integer!")
          checkpoint_parameter <- FALSE
        }
      } else {
        FSA_message("ERROR!!! Problem with DDA0003! This parameter should be at least 1 !")
        checkpoint_parameter <- FALSE
      }
    }
    ##
    if (DDA0001 == "yes") {
      x0004 <- which(PARAM_DDA[, 1] == 'DDA0004')
      if (length(x0004) == 0) {
        FSA_message("ERROR!!! Problem with DDA0004!")
        checkpoint_parameter <- FALSE
      } else {
        input_path_hrms <- PARAM_DDA[x0004, 2]
        input_path_hrms <- gsub("\\", "/", input_path_hrms, fixed = TRUE)
        PARAM_DDA[x0004, 2] <- input_path_hrms
        if (!dir.exists(input_path_hrms)) {
          FSA_message("ERROR!!! Problem with DDA0004! Please make sure the full path is provided!")
          checkpoint_parameter <- FALSE
        }
      }
    }
    ##
    refMSPcreationCheck <- FALSE
    ref_xlsx_file <- as.character(PARAM_DDA[which(PARAM_DDA[, 1] == 'DDA0005'), 2])
    if (tolower(ref_xlsx_file) != "na") {
      refMSPcreationCheck <- TRUE
      ##
      listRefXlsxAnalyzer <- CSA_reference_xlsxAnalyzer(ref_xlsx_file, input_path_hrms, PARAM = PARAM_DDA, PARAM_ID = 'DDA0005', checkpoint_parameter)
      ref_table <- listRefXlsxAnalyzer[[1]]
      PARAM_DDA <- listRefXlsxAnalyzer[[2]]
      checkpoint_parameter <- listRefXlsxAnalyzer[[3]]
      listRefXlsxAnalyzer <- NULL
      samples_string <- paste0(unique(ref_table$Filename), collapse = ";")
      ref_table <- NULL
    }
    ##
    if (DDA0001 == "yes") {
      LHRMS <- 0
      x0006 <- which(PARAM_DDA[, 1] == 'DDA0006')
      if (is.na(PARAM_DDA[x0006, 2])) {
        FSA_message("ERROR!!! Problem with DDA0006!")
        checkpoint_parameter <- FALSE
      } else {
        ##
        if (refMSPcreationCheck) {
          PARAM_DDA[x0006, 2] <- samples_string
        }
        ##
        if (tolower(PARAM_DDA[x0006, 2]) == "all") {
          file_name_hrms <- dir(path = input_path_hrms)
          file_name_hrms <- file_name_hrms[grep(pattern = ".mzML$|.mzXML$|.CDF$", file_name_hrms, ignore.case = TRUE)]
          LHRMS <- length(file_name_hrms)
          if (LHRMS == 0) {
            FSA_message("ERROR!!! Problem with DDA0006! No mzML/mzXML/CDF file was detected in the folder!")
          }
        } else {
          samples_string <- PARAM_DDA[x0006, 2]
          file_name_hrms <- strsplit(samples_string, ";")[[1]]
          LHRMS <- length(file_name_hrms)
          ndHRMS <- do.call(c, lapply(file_name_hrms, function(i) {
            if (!file.exists(paste0(input_path_hrms, "/", i))) {
              i
            }
          }))
          ##
          if (!is.null(ndHRMS)) {
            if (refMSPcreationCheck) {
              FSA_message("ERROR!!! The following file(s) can not be detected in the reference xlsx file (DDA0005) (case sensitive even for file extensions):")
            } else {
              FSA_message("ERROR!!! Problem with DDA0006! not detected the following file(s) (case sensitive even for file extensions):")
            }
            ##
            LHRMS <- LHRMS - length(ndHRMS)
            for (i in ndHRMS) {
              FSA_message(i)
            }
            checkpoint_parameter <- FALSE
          }
        }
      }
    }
    ##
    if ((DDA0001 == "yes") & (DDA_Analysis_Mode == "idsl.ipa")) {
      x0007 <- which(PARAM_DDA[, 1] == 'DDA0007')
      if (length(x0007) == 0) {
        FSA_message("ERROR!!! Problem with DDA0007!")
        checkpoint_parameter <- FALSE
      } else {
        inputPathPeaklist <- PARAM_DDA[x0007, 2]
        inputPathPeaklist <- gsub("\\", "/", inputPathPeaklist, fixed = TRUE)
        PARAM_DDA[x0007, 2] <- inputPathPeaklist
        if (!dir.exists(inputPathPeaklist)) {
          FSA_message("ERROR!!! Problem with DDA0007! Please make sure the full path is provided!")
          checkpoint_parameter <- FALSE
        } else {
          ######################################################################
          ## To see if the entire peaklists were generated for all HRMS files ##
          ######################################################################
          if (LHRMS > 0) {
            peaklistFileNames <- dir(path = inputPathPeaklist, pattern = ".Rdata$")
            peaklistFileNames <- peaklistFileNames[grep("^peaklist_", peaklistFileNames)]
            L_PL <- length(peaklistFileNames)
            ##
            if (LHRMS > L_PL) {
              checkpoint_parameter <- FALSE
              peaklistHRMSfileNames <- paste0("peaklist_", file_name_hrms, ".Rdata")
              ndPeaklists <- setdiff(peaklistHRMSfileNames, peaklistFileNames)
              ndPeaklists <- gsub("^peaklist_|.Rdata$", "", ndPeaklists)
              FSA_message("Error!!! peaklist files are not available for the following HRMS file(s):")
              for (i in ndPeaklists) {
                FSA_message(i)
              }
            }
          }
        }
      }
      ##
      listAlignmentFolderCheck <- IPA_peak_alignment_folder_xlsxAnalyzer(PARAM_DDA, PARAM_ID = 'DDA0008', checkpoint_parameter, correctedRTcheck = FALSE, CSAcheck = FALSE, allowedVerbose = TRUE)
      PARAM_DDA <- listAlignmentFolderCheck[[1]]
      checkpoint_parameter <- listAlignmentFolderCheck[[2]]
      listAlignmentFolderCheck <- NULL
      ##
      if (LHRMS == 1) {
        DDA0009 <- PARAM_DDA[which(PARAM_DDA[, 1] == "DDA0009"), 2]
        if (is.na(DDA0009)) {
          checkpoint_parameter <- FALSE
          FSA_message("ERROR!!! Problem with DDA0009! This parameter should be 'All' or a vector of indices!")
        } else if (gsub(" ", "", tolower(DDA0009)) == "all") {
          FSA_message("The enitre 12C m/z values in the peaklist were placed in the processing row!", failedMessage = TRUE)
        } else {
          peaklist <- IDSL.IPA::loadRdata(paste0(inputPathPeaklist, "/peaklist_", file_name_hrms, ".Rdata"))
          n_peaks <- dim(peaklist)[1]
          ##
          selectedIPApeaks <- tryCatch(eval(parse(text = paste0("c(", DDA0009, ")"))), error = function(e){NULL})
          if (is.null(selectedIPApeaks) | (max(selectedIPApeaks) > n_peaks)) {
            checkpoint_parameter <- FALSE
            FSA_message("ERROR!!! Problem with DDA0009! The range of indices are out of the peaklist dimension!")
          } else {
            FSA_message("The following peak IDs were selected for processing: ")
            for (id in 1:length(selectedIPApeaks)) {
              FSA_message(paste0(selectedIPApeaks[id], " - ", peaklist[selectedIPApeaks[id], 3],  " - ", peaklist[selectedIPApeaks[id], 8]))
            }
          }
        }
      }
      ##
      x0010 <- which(PARAM_DDA[, 1] == 'DDA0010')
      if (length(x0010) == 0) {
        FSA_message("ERROR!!! Problem with DDA0010!")
        checkpoint_parameter <- FALSE
      } else {
        DDA0010 <- tolower(PARAM_DDA[x0010, 2])
        if (DDA0010 == "yes" | DDA0010 == "no") {
          PARAM_DDA[x0010, 2] <- DDA0010
        } else {
          FSA_message("ERROR!!! Problem with DDA0010!")
          checkpoint_parameter <- FALSE
        }
      }
    }
    ##
    x0011 <- which(PARAM_DDA[, 1] == 'DDA0011')
    if (length(x0011) == 0) {
      FSA_message("ERROR!!! Problem with DDA0011!")
      checkpoint_parameter <- FALSE
    } else {
      output_path <- gsub("\\", "/", PARAM_DDA[x0011, 2], fixed = TRUE)
      PARAM_DDA[x0011, 2] <- output_path
      if (!dir.exists(output_path)) {
        tryCatch(dir.create(output_path, recursive = TRUE), warning = function(w){warning("Problem with DDA0011! R cannot create the folder!")})
        if (!dir.exists(output_path)) {
          checkpoint_parameter <- FALSE
        }
      }
    }
    ##
    if ((DDA0001 == "yes") & (DDA_Analysis_Mode == "idsl.ipa")) {
      ##########################################################################
      ######################### DDA .msp generation ############################
      ##########################################################################
      if (number_processing_threads > 1) {
        x0012 <- which(PARAM_DDA[, 1] == 'DDA0012')
        parallelizationMode <- PARAM_DDA[x0012, 2]
        if (is.na(parallelizationMode)) {
          FSA_message("ERROR!!! Problem with DDA0012!")
          checkpoint_parameter <- FALSE
        } else {
          parallelizationMode <- gsub(" ", "", tolower(parallelizationMode))
          if (parallelizationMode == "samplemode" | parallelizationMode == "peakmode") {
            PARAM_DDA[x0012, 2] <- parallelizationMode
          } else {
            FSA_message("ERROR!!! Problem with DDA0012!")
            checkpoint_parameter <- FALSE
          }
        }
      }
      ##
      massErrorPrecursor <- as.numeric(PARAM_DDA[which(PARAM_DDA[, 1] == 'DDA0013'), 2])
      if (length(massErrorPrecursor) == 0) {
        FSA_message("ERROR!!! Problem with DDA0013! This parameter should be a positive number!")
        checkpoint_parameter <- FALSE
      } else {
        if (massErrorPrecursor <= 0) {
          FSA_message("ERROR!!! Problem with DDA0013! This parameter should be a positive number!")
          checkpoint_parameter <- FALSE
        }
      }
      ##
      x0014 <- which(PARAM_DDA[, 1] == 'DDA0014')
      DDA0014 <- PARAM_DDA[x0014, 2]
      if (is.na(DDA0014)) {
        FSA_message("ERROR!!! Problem with DDA0014!")
        checkpoint_parameter <- FALSE
      } else {
        DDA0014 <- gsub(" ", "", tolower(DDA0014))
        if ((DDA0014 == "ddaspectraintegration") | (DDA0014 == "ionfiltering") | (DDA0014 == "mostintenseddaspectra")) {
          PARAM_DDA[x0014, 2] <- DDA0014
        } else {
          FSA_message("ERROR!!! Problem with DDA0014!")
          checkpoint_parameter <- FALSE
        }
      }
      ##
      if ((DDA0014 == "ddaspectraintegration") | (DDA0014 == "ionfiltering")) {
        massErrorIonFiltering <- as.numeric(PARAM_DDA[which(PARAM_DDA[, 1] == 'DDA0015'), 2])
        if (length(massErrorIonFiltering) == 0) {
          FSA_message("ERROR!!! Problem with DDA0015! This parameter should be a positive number!")
          checkpoint_parameter <- FALSE
        } else {
          if (massErrorIonFiltering <= 0) {
            FSA_message("ERROR!!! Problem with DDA0015! This parameter should be a positive number!")
            checkpoint_parameter <- FALSE
          }
        }
      }
      ##
      if (DDA0014 == "ionfiltering") {
        minPercentageDetectedScans <- as.numeric(PARAM_DDA[which(PARAM_DDA[, 1] == 'DDA0016'), 2])
        if (length(minPercentageDetectedScans) == 0) {
          FSA_message("ERROR!!! Problem with DDA0016! This parameter should be a positive integer between 0-100!")
          checkpoint_parameter <- FALSE
        } else {
          if (minPercentageDetectedScans < 0 | minPercentageDetectedScans > 100) {
            FSA_message("ERROR!!! Problem with DDA0016! This parameter should be a positive integer between 0-100!")
            checkpoint_parameter <- FALSE
          }
        }
        ##
        rsdCutoff <- as.numeric(PARAM_DDA[which(PARAM_DDA[, 1] == 'DDA0017'), 2])
        if (length(rsdCutoff) == 0) {
          FSA_message("ERROR!!! Problem with DDA0017! This parameter should be a positive integer between 0-100!")
          checkpoint_parameter <- FALSE
        } else {
          if (rsdCutoff < 0 | rsdCutoff > 100) {
            FSA_message("ERROR!!! Problem with DDA0017! This parameter should be a positive integer between 0-100!")
            checkpoint_parameter <- FALSE
          }
        }
        ##
        pearsonRHOthreshold <- as.numeric(PARAM_DDA[which(PARAM_DDA[, 1] == 'DDA0018'), 2])
        if (length(pearsonRHOthreshold) == 0) {
          FSA_message("ERROR!!! Problem with DDA0018! This parameter should be a positive integer between 0.5-1!")
          checkpoint_parameter <- FALSE
        } else {
          if (pearsonRHOthreshold < 0.5 | pearsonRHOthreshold > 1) {
            FSA_message("ERROR!!! Problem with DDA0018! This parameter should be a positive integer between 0.5-1!")
            checkpoint_parameter <- FALSE
          }
        }
      }
    }
    ############################################################################
    #### Unique tag aggregation by spectra similarity across entire samples ####
    ############################################################################
    if (DDA0002 == "yes") {
      x0020 <- which(PARAM_DDA[, 1] == 'DDA0020')
      DDA0020 <- PARAM_DDA[x0020, 2]
      if (is.na(DDA0020)) {
        FSA_message("ERROR!!! Problem with DDA0020!")
        checkpoint_parameter <- FALSE
      } else {
        DDA0020 <- gsub(" ", "", tolower(DDA0020))
        if (DDA0020 == "yes" | DDA0020 == "no") {
          PARAM_DDA[x0020, 2] <- DDA0020
        } else {
          FSA_message("ERROR!!! Problem with DDA0020!")
          checkpoint_parameter <- FALSE
        }
      }
      ##
      if (refMSPcreationCheck) {
        massErrorRef <- as.numeric(PARAM_DDA[which(PARAM_DDA[, 1] == 'DDA0021'), 2])
        if (length(massErrorRef) == 0) {
          FSA_message("ERROR!!! Problem with DDA0021! This parameter should be a positive number!")
          checkpoint_parameter <- FALSE
        } else {
          if (massErrorRef < 0) {
            FSA_message("ERROR!!! Problem with DDA0021! This parameter should be a positive number!")
            checkpoint_parameter <- FALSE
          }
        }
      }
      ##
      RTtoleranceRef <- as.numeric(PARAM_DDA[which(PARAM_DDA[, 1] == 'DDA0022'), 2])
      if (length(RTtoleranceRef) == 0) {
        FSA_message("ERROR!!! Problem with DDA0022! This parameter should be a positive number!")
        checkpoint_parameter <- FALSE
      } else {
        if (RTtoleranceRef < 0) {
          FSA_message("ERROR!!! Problem with DDA0022! This parameter should be a positive number!")
          checkpoint_parameter <- FALSE
        }
      }
      ##
      if (!refMSPcreationCheck) {
        minDDAdetectionFrequency <- as.numeric(PARAM_DDA[which(PARAM_DDA[, 1] == 'DDA0023'), 2])
        if (length(minDDAdetectionFrequency) == 0) {
          FSA_message("ERROR!!! Problem with DDA0023! This parameter should be a positive number between 0 - 100!")
          checkpoint_parameter <- FALSE
        } else {
          if (!((minDDAdetectionFrequency > 0) & (minDDAdetectionFrequency < 100))) {
            FSA_message("ERROR!!! Problem with DDA0023! This parameter should be a positive number between 0 - 100!")
            checkpoint_parameter <- FALSE
          }
        }
      }
      ##
      x0024 <- which(PARAM_DDA[, 1] == 'DDA0024')
      allowedWeightedSpectralEntropy <- tolower(gsub(" ", "", PARAM_DDA[x0024, 2]))
      if (allowedWeightedSpectralEntropy == "1" | allowedWeightedSpectralEntropy == "t" | allowedWeightedSpectralEntropy == "true") {
        allowedWeightedSpectralEntropy <- TRUE
      } else {
        allowedWeightedSpectralEntropy <- FALSE
      }
      PARAM_DDA[x0024, 2] <- allowedWeightedSpectralEntropy
      ##
      minEntropySimilarity <- as.numeric(PARAM_DDA[which(PARAM_DDA[, 1] == 'DDA0025'), 2])
      if (length(minEntropySimilarity) == 0) {
        FSA_message("ERROR!!! Problem with DDA0025! This parameter should be a positive number between 0 - 1!")
        checkpoint_parameter <- FALSE
      } else {
        if (!((minEntropySimilarity >= 0) & (minEntropySimilarity <= 1))) {
          FSA_message("ERROR!!! Problem with DDA0025! This parameter should be a positive number between 0 - 1!")
          checkpoint_parameter <- FALSE
        }
      }
    }
  }
  ##############################################################################  
  if (!checkpoint_parameter) {
    PARAM_DDA <- NULL
  }
  ##
  return(PARAM_DDA)
}