% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatters.R
\name{ucov}
\alias{ucov}
\alias{scov}
\title{Simple robust estimates of scatter}
\usage{
scov(x, beta = 0.2)

ucov(x, beta = 0.2)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{beta}{a positive numeric value specifying the tuning parameter of the
estimator (defaults to 0.2), see \sQuote{Details}.}
}
\value{
A numeric matrix giving the estimate of the scatter matrix.
}
\description{
Compute a one-step M-estimator of scatter with weights based on Mahalanobis
distances, or a simple related estimator that is based on a transformation.
}
\details{
For a sample \eqn{\boldsymbol{X}_{n} = (\mathbf{x}_{1}, \dots, 
\mathbf{x}_n)^{\top}}, a positive and decreasing weight function \eqn{w},
and a tuning parameter \eqn{\beta > 0}, the one-step M-estimator
of scatter is defined as
\deqn{\mathrm{SCOV}_{\beta}(\boldsymbol{X}_{n}) =
\frac{\sum_{i=1}^{n} 
w(\beta \, r^{2}(\mathbf{x}_{i})) 
(\mathbf{x}_{i} - \mathbf{\bar{x}}_{n}) 
(\mathbf{x}_{i} -  \mathbf{\bar{x}}_{n})^{\top}}{\sum_{i=1}^{n} 
w(\beta \, r^{2}(\mathbf{x}_{i}))},}
where
\deqn{r^{2}(\mathbf{x}_{i}) = 
(\mathbf{x}_{i} -  \mathbf{\bar{x}}_{n})^{\top}
\mathrm{COV}(\boldsymbol{X}_n)^{-1} 
(\mathbf{x}_{i} -  \mathbf{\bar{x}}_{n})}
denotes the squared Mahalanobis distance of observation \eqn{\mathbf{x}_{i}}
from the sample mean \eqn{\mathbf{\bar{x}}_{n}} based on the sample
covariance matrix \eqn{\mathrm{COV}(\boldsymbol{X}_n)}. Here, the weight
function \eqn{w(x) = \exp(-x/2)} is used.

A simple robust estimator that is consistent under normality is obtained via
the transformation
\deqn{\mathrm{UCOV}_{\beta}(\boldsymbol{X}_{n}) = 
(\mathrm{SCOV}_{\beta}(\boldsymbol{X}_{n})^{-1} - 
\beta \, \mathrm{COV}(\boldsymbol{X}_{n})^{-1})^{-1}.}
}
\references{
Caussinus, H. and Ruiz-Gazen, A. (1993) Projection Pursuit and Generalized
Principal Component Analysis. In Morgenthaler, S., Ronchetti, E., Stahel,
W.A. (eds.) \emph{New Directions in Statistical Data Analysis and Robustness},
35-46. Monte Verita, Proceedings of the Centro Stefano Franciscini Ascona
Series. Springer-Verlag.

Caussinus, H. and Ruiz-Gazen, A. (1995) Metrics for Finding Typical
Structures by Means of Principal Component Analysis. In \emph{Data Science and
its Applications}, 177-192. Academic Press.

Ruiz-Gazen, A. (1996) A Very Simple Robust Estimator of a Dispersion Matrix.
\emph{Computational Statistics & Data Analysis}, \strong{21}(2), 149-162.
\doi{10.1016/0167-9473(95)00009-7}.
}
\seealso{
\code{\link{ICS_ucov}()}, \code{\link{tcov}()}, \code{\link{ICS_tcov}()}
}
\author{
Andreas Alfons and Aurore Archimbaud
}
