% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatters.R
\name{tcov}
\alias{tcov}
\title{Pairwise one-step M-estimate of scatter}
\usage{
tcov(x, beta = 2)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{beta}{a positive numeric value specifying the tuning parameter of the
pairwise one-step M-estimator (defaults to 2), see \sQuote{Details}.}
}
\value{
A numeric matrix giving the pairwise one-step M-estimate of scatter.
}
\description{
Computes a pairwise one-step M-estimate of scatter with weights based on
pairwise Mahalanobis distances. Note that it is based on pairwise
differences and therefore does not require a location estimate.
}
\details{
For a sample \eqn{\boldsymbol{X}_{n} = (\mathbf{x}_{1}, \dots, 
\mathbf{x}_n)^{\top}}, a positive and decreasing weight function \eqn{w},
and a tuning parameter \eqn{\beta > 0}, the pairwise one-step M-estimator
of scatter is defined as
\deqn{\mathrm{TCOV}_{\beta}(\boldsymbol{X}_{n}) =
\frac{\sum_{i=1}^{n-1} \sum_{j=i+1}^{n} 
w(\beta \, r^{2}(\mathbf{x}_{i}, \mathbf{x}_{j})) 
(\mathbf{x}_{i} - \mathbf{x}_{j}) 
(\mathbf{x}_{i} - \mathbf{x}_{j})^{\top}}{\sum_{i=1}^{n-1} \sum_{j=i+1}^{n} 
w(\beta \, r^{2}(\mathbf{x}_{i}, \mathbf{x}_{j}))},}
where
\deqn{r^{2}(\mathbf{x}_{i}, \mathbf{x}_{j}) = 
(\mathbf{x}_{i} - \mathbf{x}_{j})^{\top}
\mathrm{COV}(\boldsymbol{X}_n)^{-1} 
(\mathbf{x}_{i} - \mathbf{x}_{j})}
denotes the squared pairwise Mahalanobis distance between observations
\eqn{\mathbf{x}_{i}} and \eqn{\mathbf{x}_{j}} based on the sample
covariance matrix \eqn{\mathrm{COV}(\boldsymbol{X}_n)}. Here, the weight
function \eqn{w(x) = \exp(-x/2)} is used.
}
\references{
Caussinus, H. and Ruiz-Gazen, A. (1993) Projection Pursuit and Generalized
Principal Component Analysis. In Morgenthaler, S., Ronchetti, E., Stahel,
W.A. (eds.) \emph{New Directions in Statistical Data Analysis and Robustness},
35-46. Monte Verita, Proceedings of the Centro Stefano Franciscini Ascona
Series. Springer-Verlag.

Caussinus, H. and Ruiz-Gazen, A. (1995) Metrics for Finding Typical
Structures by Means of Principal Component Analysis. In \emph{Data Science and
its Applications}, 177-192. Academic Press.
}
\seealso{
\code{\link{ICS_tcov}()}, \code{\link{ucov}()}, \code{\link{ICS_ucov}()}
}
\author{
Andreas Alfons and Aurore Archimbaud
}
