% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{get_stats}
\alias{get_stats}
\title{Metrics for Predictive Performance}
\usage{
get_stats(
  predictions,
  biomarker_values,
  model = "",
  threshold = 300,
  metrics = c("R", "AUPRC")
)
}
\arguments{
\item{predictions}{(list)
A list with two elements, 'predictions' and 'panel_lengths',
as produced by the function get_predictions().}

\item{biomarker_values}{(dataframe)
A dataframe with two columns, 'Tumor_Sample_Barcode' and a
column with the name of the biomarker in question containing values.}

\item{model}{(character)
The name of the model type producing these predictions.}

\item{threshold}{(numeric)
The threshold for biomarker high/low categorisation.}

\item{metrics}{(character)
A vector of the names of metrics to calculate.}
}
\value{
dataframe with 5 columns:
\itemize{
\item panel_length: the length of each panel.
\item model: the model that produced the predictions.
\item biomarker: the name of the biomarker in question.
\item stat: the metric values for each panel.
\item metric: the name of the metric.
}
}
\description{
A function to return a variety metrics for predictions vs actual values. Works well when piped to straight from get_predictions().
}
\examples{
example_stat <- get_stats(predictions = get_predictions(example_refit_panel,
new_data = example_tables$val), biomarker_values = example_tmb_tables$val,
model = "Refitted T", threshold = 10)
}
