% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_related_functions.R
\name{StrelkaIDVCFFilesToCatalog}
\alias{StrelkaIDVCFFilesToCatalog}
\title{Create ID (small insertion and deletion) catalog from Strelka ID VCF files}
\usage{
StrelkaIDVCFFilesToCatalog(
  files,
  ref.genome,
  region = "unknown",
  names.of.VCFs = NULL,
  flag.mismatches = 0
)
}
\arguments{
\item{files}{Character vector of file paths to the Strelka ID VCF files.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}

\item{names.of.VCFs}{Optional. Character vector of names of the VCF files.
The order of names in \code{names.of.VCFs} should match the order of VCF
file paths in \code{files}. If \code{NULL}(default), this function will
remove all of the path up to and including the last path separator (if any)
in \code{files} and file paths without extensions (and the leading dot)
will be used as the names of the VCF files.}

\item{flag.mismatches}{Optional. If > 0, then if there are mismatches to
references in the ID (insertion/deletion) VCF, generate messages showing
the mismatched rows and continue. Otherwise \code{stop} if there are
mismatched rows. See \code{\link{AnnotateIDVCF}} for more details.}
}
\value{
A list of two elements. 1st element is an S3 object containing an ID
  (small insertion and deletion) catalog with class "IndelCatalog". See
  \code{\link{as.catalog}} for more details. 2nd element is a list of further
  annotated VCFs.
}
\description{
Create ID (small insertion and deletion) catalog from the Strelka ID VCFs
specified by \code{files}
}
\details{
This function calls \code{\link{VCFsToIDCatalogs}}
}
\note{
In ID (small insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation
  deletion repeat sizes range from 1 to 6+.
}
\examples{
file <- c(system.file("extdata/Strelka-ID-vcf",
                      "Strelka.ID.GRCh37.s1.vcf",
                      package = "ICAMS"))
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  catID <- StrelkaIDVCFFilesToCatalog(file, ref.genome = "hg19", 
                                      region = "genome")}
}
