% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{mk_model}
\alias{mk_model}
\title{Creates a model for IBMPopSim.}
\usage{
mk_model(
  characteristics = NULL,
  events,
  parameters = NULL,
  with_id = FALSE,
  with_compilation = TRUE
)
}
\arguments{
\item{characteristics}{List containing names and types of characteristics of individuals in the population. See \code{\link{get_characteristics}}.}

\item{events}{List of events in the model. See \code{\link{mk_event_poisson}}, \code{\link{mk_event_inhomogeneous_poisson}}, \code{\link{mk_event_individual}}, and \code{\link{mk_event_interaction}}.}

\item{parameters}{Model parameters. A list of parameters of the model.}

\item{with_id}{\emph{(Optional)} Logical argument, \code{FALSE} by default. If \code{TRUE}, each individuals is given a unique \code{id}, which allows the identification of individual life histories in the presence of swap events.}

\item{with_compilation}{\emph{(Optional)} Logical parameter, \code{TRUE} by default. If \code{FALSE} the \code{sourceCpp} function is not called.}
}
\value{
model List containing the built model :
\itemize{
\item \code{individual_type}: Names and types (R and C++) of characteristics.
\item \code{parameters_types}: Names and types (R and C++) of model parameters.
\item \code{events}: List of events.
\item \code{cpp_code}: Output of C++ compilation.
}
}
\description{
This function creates an Individual Based Model describing the population, events which can occur in the population, and the model parameters.
}
\details{
It builds the C++ model code and produces the function \code{popsim_cpp} which will be used for simulating the model. The function used to simulate a population from a model is \code{\link{popsim}}.
}
\examples{
\donttest{
params <- list("p_male"= 0.51,
              "birth_rate" = stepfun(c(15,40),c(0,0.05,0)),
              "death_rate" = gompertz(0.008,0.02))

death_event <- mk_event_individual(type = "death",
                                  intensity_code = "result = death_rate(age(I,t));")

birth_event <- mk_event_individual(type = 'birth',
                                  intensity_code = "if (I.male) result = 0;
                                    else result=birth_rate(age(I,t));",
                                  kernel_code = "newI.male = CUnif(0, 1) < p_male;")

model <- mk_model(characteristics = get_characteristics(EW_pop_14$sample),
                 events = list(death_event,birth_event),
                 parameters = params)

summary(model)
}

}
\seealso{
\code{\link{popsim}}, \code{\link{mk_event_poisson}}, \code{\link{mk_event_individual}}, \code{\link{mk_event_interaction}}.
}
