% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooOth.R
\name{DTh}
\alias{DTh}
\title{Density, Function of Temperature and Enthalpy}
\usage{
DTh(Temp, h, digits = 9)
}
\arguments{
\item{Temp}{Temperature in Kelvin}

\item{h}{Enthalpy in [ kJ kg-1 ]}

\item{digits}{Digits of results (optional)}
}
\value{
The Density 1: Density_1 [ kg m-3 ]

The Density 2: Density_2 [ kg m-3 ]

Error Message (if an error occur: \link{errorCodes})
}
\description{
The function \code{DTh(Temp,h,digits=9)} returns the water density, D [ kg m-3 ],
     for given Temp [K] and h [ kJ kg-1 ] (it may have two solutions for Density).
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
Temp <- 500.
h <- 977.181624
D_Th <- DTh(Temp,h)
D_Th

}
