% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooOth.R
\name{BT}
\alias{BT}
\title{Second Virial Coefficient (B), Function of Temperature}
\usage{
BT(Temp, digits = 9)
}
\arguments{
\item{Temp}{Temperature [K]}

\item{digits}{Digits of results (optional)}
}
\value{
The second virial coefficient: B [ m3 kg-1 ] and an Error Message 
    (if an error occur: \link{errorCodes})
}
\description{
The function \code{BT(Temp,digits=9)} returns the second virial coefficient,
     B [ m3 kg-1 ], for a given T [K].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
Temp <- 500.
B_T <- BT(Temp)
B_T

}
