% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upstream.R
\name{is.upstream}
\alias{is.upstream}
\alias{\%up\%}
\alias{is.downstream}
\alias{\%down\%}
\title{Comparison of Pfafstetter Coded Basins}
\usage{
is.upstream(a, b)

a \%up\% b

is.downstream(a, b)

a \%down\% b
}
\arguments{
\item{a}{numeric, Pfafstetter coded point}

\item{b}{numeric, one or more Pfaffstetter coded points}
}
\value{
a vector of type logical
}
\description{
One point (river segment or subbasin) with Pfafstetter code \bold{a}
on the water system can be queried for beeing upstream or downstream
as compared to one or many points \bold{b} on the water system.
}
\details{
For the scientific background of the Pfafstetter coding system see
the literature reference.

The following option(s) can be set via,
e.g. \code{options("hydrocode.X" = XX)}:

\describe{
 \item{\code{hydrocode.parallel}:}{logical. Defaults to \code{FALSE}.
 The runtime may or may not decrease for very large vectors (length > 50000)
 on multi-threading processors.}
 \item{\code{hydrocode.alloddorzero}:}{logical. Defaults to \code{FALSE}.
 This refers to the original Pfafstetter coding system and tests, whether
 all \code{n} numbers are odd, \code{[13579]\{n\}}. Hydrocodes that contain
 the digit \code{0} are interpreted as closed catchments (endorheic basins).
 This setting works, e.g. with the Pfafstetter coded table \code{riversegments} of
\emph{CCM River and Catchment Database, v2.1} (European Commission - JRC, 2007;
Vogt et al., 2007).
 For decoding the Pfafstetter coded tables of the \emph{HydroBASIN, v1c} dataset
 (Lehner and Grill, 2013), this option should be set to
 \code{options("hydrocode.alloddorzero" = TRUE)}. This tests for all \code{n}
 numbers are odd or zero, \code{[013579]\{n\}}.}
}
}
\examples{
## example from Wikipedia
## 8835 is upstream of segments 8833 and 8811,
## but not segments 8832, 8821 or 9135
dwn <- c(8833, 8811, 8832, 8821, 9135)
is.upstream(8835, dwn)

## works with operator
8835 \%up\% dwn

## this will produce errors
\donttest{
is.upstream("12h", 123)
is.upstream(12.4, 123)
}

## example from Verdin and Verdin, 1999, p. 10
b <- c(8883, 8881, 8879, 8877, 8875, 8873, 8871, 8859,
       8857, 8855, 8853, 8851, 8839, 8837, 8835, 8833,
       8831, 8819, 8817, 8815, 8813, 8811, 8886, 8887,
       8888, 8889)
a <- 8885
a \%down\% b

## example from Vogt et al. (2007),
## pollution source at 464.
## Which subcatchments are
## affected? Mixed levels of subdivisions.
a <- 464
b <- c(465, 466, 467, 47, 48, 49,
       463, 461, 41, 43, 45, 452,
       454)
a \%up\% b

## same hydro codes return TRUE per default
112 \%up\% 112
112 \%down\% 112

}
\references{
A. L. de Jager and J. V. Vogt, 2010,
Development and Demonstration of a
Structured Hydrological Feature Coding
System for Europe,
\emph{Hydrological Sciences Journal}, \bold{55},
661--75, \doi{10.1080/02626667.2010.490786}.

B. Lehner and G. Grill, 2013, Global river hydrography and network
routing: baseline data and new approaches to study the world’s
large river systems, \emph{Hydrological Processes}, \bold{27},
2171--2186, \doi{10.1002/hyp.9740}.

K. L. Verdin and J. P. Verdin, 1999,
A topological system for delineation and codification
of the Earth’s river basins,
\emph{Journal of Hydrology}, \bold{218}, 1--12,
\doi{10.1016/S0022-1694(99)00011-6}.

J. Vogt, P. Soille, A. de Jager, E. Rimavičiūtė,
W. Mehl, S. Foisneau, K. Bódis, et al., 2007,
\emph{A Pan-European River and Catchment Database},
Publications Office: Luxembourg, \doi{10.2788/35907}.

Wikipedia contributors, 2019,
Pfafstetter Coding System,
In \emph{Wikipedia, The Free Encyclopedia},
Retrieved 13:23, November 9, 2019,
\url{https://en.wikipedia.org/w/index.php?title=Pfafstetter_Coding_System&oldid=907987995}
}
\seealso{
\code{\link{options}}
}
\keyword{logic}
\keyword{math}
