% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/print.HydeNetwork.R
\name{print.HydeNetwork}
\alias{print.HydeNetwork}
\title{Print a HydeNetwork}
\usage{
\method{print}{HydeNetwork}(x, ...)
}
\arguments{
\item{x}{a \code{HydeNetwork object}}

\item{...}{additional arguments to be passed to print methods.  Currently
  none in use.}
}
\description{
Print a HydeNetwork
}
\details{
Prints a HydeNetwork object with a brief summary of each node.
}
\examples{
data(PE, package="HydeNet")
Net <- HydeNetwork(~ wells +
                     pe | wells +
                     d.dimer | pregnant*pe +
                     angio | pe +
                     treat | d.dimer*angio +
                     death | pe*treat)
print(Net)
print(Net, d.dimer)

Net <- setNode(Net, d.dimer,
                  nodeType='dnorm', mu=fromData(), tau=fromData(),
                  nodeFormula = d.dimer ~ pregnant + pe,
                  nodeFitter='lm')
print(Net, d.dimer)
}
\author{
Jarrod Dalton and Benjamin Nutter
}

