% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Met_MatH.R
\docType{methods}
\name{WH.vec.sum}
\alias{WH.vec.sum}
\alias{WH.vec.sum,MatH-method}
\title{Method WH.vec.sum}
\usage{
WH.vec.sum(object, ...)

\S4method{WH.vec.sum}{MatH}(object, w = numeric(0))
}
\arguments{
\item{object}{a \code{MatH} object}

\item{...}{optional arguments}

\item{w}{it is possible to add a vector of weights (positive numbers) having the same size of the \code{MatH object},
default = equal weights for all cells}
}
\value{
a \code{distributionH} object, i.e. a histogram
}
\description{
Method WH.vec.sum

Compute a histogram that is the weighted sum of the set of histograms contained
in a \code{MatH} object, i.e. a matrix of histograms, consistent with
a set of distributions equipped with a L2 wasserstein metric.
}
\examples{
hsum<-WH.vec.sum(BLOOD)
# generate a set of random weights
RN<-runif(get.MatH.nrows(BLOOD)*get.MatH.ncols(BLOOD))
hsum<-WH.vec.sum(BLOOD,w=RN)
}

