% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Met_MatH.R
\docType{methods}
\name{is.registeredMH}
\alias{is.registeredMH}
\alias{is.registeredMH,MatH-method}
\title{Method is.registeredMH}
\usage{
is.registeredMH(object)

\S4method{is.registeredMH}{MatH}(object)
}
\arguments{
\item{object}{A \code{MatH} object}
}
\value{
a \code{logical} value \code{TRUE} if the distributions share the
same cdf, \code{FALSE} otherwise.
}
\description{
Method is.registeredMH

Checks if a \code{MatH} contains histograms described by the same number of
bins and the same cdf.
}
\examples{
##---- initialize three distributionH objects mydist1 and mydist2
 mydist1=new("distributionH",c(1,2,3),c(0, 0.4, 1))
 mydist2=new("distributionH",c(7,8,10,15),c(0, 0.2, 0.7, 1))
 mydist3=new("distributionH",c(9,11,20),c(0, 0.8, 1))
 ## create a MatH object
 MyMAT=new("MatH",nrows=1,ncols=3,ListOfDist=c(mydist1,mydist2,mydist3), 1,3)
 is.registeredMH(MyMAT)
 ## [1] FALSE #the distributions do not share the same cdf
 ## Hint: check with str(MyMAT)

 ## register the two distributions
 MATregistered=registerMH(MyMAT)
 is.registeredMH(MATregistered)
 ## TRUE #the distributions share the same cdf
 ## Hint: check with str(MATregistered)
}
\author{
Antonio Irpino
}
\references{
Irpino, A., Lechevallier, Y. and Verde, R. (2006): \emph{Dynamic
clustering of histograms using Wasserstein metric} In: Rizzi, A., Vichi, M.
(eds.) COMPSTAT 2006. Physica-Verlag, Berlin, 869-876.\cr Irpino, A.,Verde,
R. (2006): \emph{A new Wasserstein based distance for the hierarchical
clustering of histogram symbolic data} In: Batanjeli, V., Bock, H.H.,
Ferligoj, A., Ziberna, A. (eds.) Data Science and Classification, IFCS 2006.
Springer, Berlin, 185-192.
}
\keyword{distribution}

