% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/unsuperv_classification.R
\name{WH_hclust}
\alias{WH_hclust}
\title{Hierarchical clustering of histogram data}
\usage{
WH_hclust(x, simplify = FALSE, qua = 10, standardize = FALSE,
  distance = "WDIST", method = "complete")
}
\arguments{
\item{x}{A MatH object (a matrix of distributionH).}

\item{simplify}{A logic value (default is FALSE), if TRUE histograms are recomputed in order to speed-up the algorithm.}

\item{qua}{An integer, if \code{simplify}=TRUE is the number of quantiles used for recodify the histograms.}

\item{standardize}{A logic value (default is FALSE). If TRUE, histogram-valued data are standardized,  variable by variable,
using the Wassertein based standard deviation. Use if one wants to have variables with std equal to one.}

\item{distance}{A string default "WDIST" the L2 Wasserstein distance (other distances will be implemented)}

\item{method}{A string, default="complete", is the the agglomeration method to be used.}
}
\value{
An object of class hclust which describes the tree produced by
 the clustering process.
}
\description{
The function implements a Hierarchical clustering
 for a set of histogram-valued data, based on the L2 Wassertein distance.
 Extends the \code{hclust} function of the \pkg{stat} package.
}
\examples{
results=WH_hclust(x = BLOOD,simplify = TRUE, method="complete")
}
\references{
Irpino A., Verde R. (2006). A new Wasserstein based distance for the hierarchical clustering
of histogram symbolic data. In: Batanjeli et al. Data Science and Classification, IFCS 2006. p. 185-192,
 BERLIN:Springer, ISBN: 3-540-34415-2
}
\seealso{
\code{\link{hclust}} of \pkg{stat} package for further details.
}

