% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tide.info.R
\name{tide.info}
\alias{tide.info}
\title{Annual tide calendar for one particular location}
\usage{
tide.info(
  location = NULL,
  year = 2021,
  longitude = NULL,
  latitude = NULL,
  force.tide.height = TRUE
)
}
\arguments{
\item{location}{Textual information about location name}

\item{year}{Year to get the calendar}

\item{longitude}{Longitude to search for}

\item{latitude}{Latitude to search for}

\item{force.tide.height}{If FALSE, can return a current speed rather than tide height}
}
\value{
Return a data.frame with annual tide calendar.
}
\description{
Annual tide information.\cr
The columns are: Location, Longitude, Latitude, Phase, DateTime.local, DateTime.UTC, Tide.meter\cr
This function uses an API linking xtide software
(https://flaterco.com/xtide/) with tide.info() function.\cr
You must have a working internet connection for this function.
}
\details{
tide.info gets the annual tide calendar for one particular location.
}
\examples{
\dontrun{
library("HelpersMG")
Location <- "Les Hattes"
Year <- 2010
tide <- tide.info(Location, Year)
plot(tide[, "DateTime.local"], tide[, "Tide.meter"], 
     type="l", bty="n", las=1, 
     main=tide[1, "Location"], 
     xlab=as.character(Year), ylab="Tide level in meter")

Location <- "Hawaii"
Year <- 2010
tide <- tide.info(Location, Year)

Location <- "Hanamaulu Bay, Kauai Island, Hawaii"
Year <- 2010
tide <- tide.info(Location, Year)
plot(tide[, "DateTime.local"], tide[, "Tide.meter"], 
     type="l", bty="n", las=1, 
     main=tide[1, "Location"], 
     xlab=as.character(Year), ylab="Tide level in meter")
     
tide <- tide.info(year=2010, longitude=-32, latitude=-4)
library(maps)
map(database = "world", regions = "Brazil", asp=1, 
    xlim=c(-80, -30), ylim=c(-33, 5))
points(tide[1, "Longitude"], tide[1, "Latitude"], col="red", pch=19)
points(-32, -4, col="blue", pch=19)
axis(1)
axis(2, las=1)

# Show the locations with data    
library(maps)
map(xlim=c(-180, 180), ylim=c(-90, 90))
title("Locations with harmonics data")
axis(1, at=seq(from=-180, to=180, by=45))
axis(2, las=1, at=seq(from=-90, to=90, by=15))
points(getFromNamespace(x="tide_location", ns="HelpersMG")[, c("longitude")], 
       getFromNamespace(x="tide_location", ns="HelpersMG")[, c("latitude")], 
       pch=".", col="red", cex=2)
# Another example
tikei_lon  <- (-144.5465183)
tikei_lat <- -14.9505897
Year <- 2021
tikei_tide <- tide.info(year=Year, longitude=tikei_lon, latitude=tikei_lat)
plot(tikei_tide[, "DateTime.local"], tikei_tide[, "Tide.meter"], 
     type="l", bty="n", las=1, 
     main=tikei_tide[1, "Location"], 
     xlab=as.character(Year), ylab="Tide level in meter")
## Another one
tikei_lon <- (-75.56861111)
tikei_lat <- 39.50083333
Year <- 2012
tikei_tide <- tide.info(year=Year, longitude=tikei_lon, latitude=tikei_lat)

library(mapdata)
map('worldHires', xlim=c(-77, -74), ylim=c(37, 40))
points(x=tikei_lon, y=tikei_lat, pch=19, col="red", cex=1)
points(x=tikei_tide$Longitude[1], y=tikei_tide$Latitude[2], 
       pch=19, col="blue", cex=1)

par(mar=c(4, 4, 2, 2))
plot(tikei_tide$DateTime.local, tikei_tide$Tide.meter, type="l")
}
}
\seealso{
Other Periodic patterns of indices: 
\code{\link{index.periodic}()},
\code{\link{minmax.periodic}()},
\code{\link{moon.info}()},
\code{\link{sun.info}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Periodic patterns of indices}
\keyword{Tide}
