% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RM_get.R
\name{RM_get}
\alias{RM_get}
\title{Get a value in a results managment to an object}
\usage{
RM_get(
  x = stop("An object with results managment must be provided"),
  RM = "RM",
  RMname = NULL,
  valuename = NULL
)
}
\arguments{
\item{x}{The object in which to get a result in a results managment}

\item{RM}{The name of results managment stored}

\item{RMname}{The name of the results managment to be read}

\item{valuename}{The name of the value to be read}
}
\value{
Return a value in a results managment object
}
\description{
Return the value valuename of the results managment RMname.
}
\details{
RM_get gets a value in results managment to an object
}
\examples{
\dontrun{
library("HelpersMG")
# Let an object of class objclass being created
obj <- list(A=100, name="My object")
class(obj) <- "objclass"
# And now I create a RM to this object
obj <- RM_add(x=obj, RMname="NewAnalysis1")
RM_list(obj)
obj <- RM_add(x=obj, RMname="NewAnalysis2")
RM_list(obj)
obj <- RM_add(x=obj, RMname="NewAnalysis2", valuename="V1", value=100)
RM_get(x=obj, RMname="NewAnalysis2", valuename="V1")
}
}
\seealso{
Other Results Managment: 
\code{\link{RM_add}()},
\code{\link{RM_delete}()},
\code{\link{RM_duplicate}()},
\code{\link{RM_list}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Results Managment}
