#' logLik.LD50 Return Log Likelihood of a fit for LD50
#' @title Return Log Likelihood of a fit generated by LD50
#' @author Marc Girondot
#' @return The Log Likelihood value for the fitted model with data
#' @param object A result file generated by fitRMU
#' @param ... Not used
#' @description Return Log Likelihood of a fit generated by LD50
#' @family LD50 functions
#' @examples
#' \dontrun{
#' data <- data.frame(Doses=c(80, 120, 150, 150, 180, 200),
#' Alive=c(10, 12, 8, 6, 2, 1),
#' Dead=c(0, 1, 5, 6, 9, 15))
#' LD50_logistic <- LD50(data, equation="logistic")
#' logLik(LD50_logistic)
#' AIC(LD50_logistic)
#' }
#' @method logLik LD50
#' @export


logLik.LD50 <- function(object, ...) {
  l <- -object$value
  n <- sum(!is.na(as.numeric(as.matrix(object$data))))
  attributes(l) <- list(nall=n , nobs=n , df=length(object$par) , class="logLik")
  return(l)
}
