% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram.R
\name{defaultHistobounds}
\alias{defaultHistobounds}
\alias{makeHistogram}
\title{Functions to plot a histogram of test statistic}
\usage{
defaultHistobounds(ostats, statID, m)

makeHistogram(x, curveColor = "blue", color1 = "gray40",
  color2 = "lightcoral")
}
\arguments{
\item{ostats}{Observed statistics for the 4 test measures, \code{LLR}, \code{Prob}, \code{U} and \code{Chisq}.}

\item{statID}{Value 1-4 indicating which statistic to use for the plot.}

\item{m}{vector of allele counts}

\item{x}{output from \code{\link{hwx.test}}}

\item{curveColor}{color for the asymptotic distribution curve}

\item{color1}{The color for outcomes fitting the null distribution better than the observed}

\item{color2}{The color for outcomes deviating from the null at leasst as much as observed. Area of \code{color2} is the P value.}
}
\value{
\code{defaultHistobounds} returns a vector containing the left and right boundaries for the x axis. This function is not normally called by the user

\code{makeHistobram} A graphic object of class \dQuote{gg} or \dQuote{ggplot} from \code{ggplot2}.
}
\description{
Running the function \code{\link{hwx.test}} can create data for a frequency distribution plot of one of the four test statistics provided the parameter \code{histobins} is positive. These plotting data are contained within the \dQuote{hwtest} object generated by \code{\link{hwx.test}}. When that object is printed, a plot is drawn by \code{ggplot2}. If the user wishes to capture the \code{ggplot2} results, such as to use in making a composite figure, the \dQuote{gg} object can be obtained by calling \code{makeHistogram}.
}
\seealso{
\code{\link{hwx.test}}
}

