% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{hrm.plot}
\alias{hrm.plot}
\title{Plots profiles of the groups in case of one whole- and one subplot-factor.}
\usage{
hrm.plot(data, group, factor1, subject, response, xlab = "time",
  ylab = "mean", legend = TRUE, legend.title = NULL)
}
\arguments{
\item{data}{A data.frame containing the data}

\item{group}{column name within the data frame data specifying the groups}

\item{factor1}{column name within the data frame data specifying the first subplot-factor}

\item{subject}{column name within the data frame X identifying the subjects}

\item{response}{column name within the data frame X containing the response variable}

\item{xlab}{label of the x-axis of the plot}

\item{ylab}{label of the y-axis of the plot}

\item{legend}{logical indicating if a legend should be plotted}

\item{legend.title}{title of the legend}
}
\value{
Plots profiles of the groups.
}
\description{
Plots profiles of the groups in case of one whole- and one subplot-factor.
}
\examples{
data(EEG)
head(EEG)

# plots profiles according to groups with
# subplot-factor called dimension

# first create an HRM object
object_hrm <- hrm_test(value ~ group*dimension, subject = "subject", data = EEG)

# plot the HRM object, here we use the additional argument 'theme_bw()' for ggplot2
plot(object_hrm, legend = TRUE, legend.title = "Group", ... =  theme_bw() )

# same plot without a legend
# note that 'theme_bw' overwrites the standard legend properties of plot.HRM
plot(object_hrm, ... =  theme_bw() +
  theme(legend.title = element_blank(), legend.position="none") )
}
\keyword{internal}
