% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Repeated.R
\name{hrm_test}
\alias{hrm_test}
\title{Test for main effects and interaction effects of one or two between-subject factors and one or two within-subject factors}
\usage{
hrm_test(formula, data, alpha = 0.05, subject)
}
\arguments{
\item{formula}{A model formula object. The left hand side contains the response variable and the right hand side contains the whole- and subplot factors.}

\item{data}{A data.frame containing the data. The columns containing the factor variables need to have the type 'factor'. One column is needed to indentify the subjects.}

\item{alpha}{alpha level used for the test}

\item{subject}{column name within the data frame X identifying the subjects}
}
\value{
Returns a data frame consisting of the degrees of freedom, the test value, the critical value and the p-value
}
\description{
Test for main effects and interaction effects of one or two between-subject factors and one or two within-subject factors
}
\examples{
data(EEG)

hrm_test(value ~ group*region+variable+variable:region-group,
           data = EEG, alpha=0.05, subject="subject")

}

