% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessoryFunctions.R
\name{addCodonLine}
\alias{addCodonLine}
\title{Add an 'AA codon' Line to Alignments When Missing.}
\usage{
addCodonLine(cDNAalign, firstPos, afterLine = 8, codons = 25)
}
\arguments{
\item{cDNAalign}{A matrix of cDNA alignment lines, generated from an alignment file that is missing "AA codon" lines.}

\item{firstPos}{A numeric value identifying the position number of the transcript's N-terminal codon, based on a complete cDNA alignment in another release.}

\item{afterLine}{A numeric value identifying the number of the line below the first "cDNA" line in the alignment. The default value is 8.}

\item{codons}{A numeric value identifying the number of codons in each line of the nucleotide alignment. The default value is 25.}
}
\value{
A complete cDNA alignment data frame that includes "AA codon" rows.
}
\description{
Modifies cDNA alignment objects that are missing "AA codon" lines to include these lines in the correct location with the correct codon position information.
}
\note{
For internal HLAtools use.
}
