% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmstat.attrVar.R
\name{mmstat.attrVar}
\alias{mmstat.attrVar}
\title{mmstat.attrVar}
\usage{
mmstat.attrVar(var, type, index = NULL)
}
\arguments{
\item{var}{vector: values of a mmstat variable}

\item{type}{character: type of values, allowed are \code{numvars}, \code{binvars}, \code{ordvars} or \code{facvars}}

\item{index}{integer: observation numbers to use for computation, default is to use all observations}
}
\value{
descriptive measures
}
\description{
Returns the parameters for a variable. If \code{type="numeric"} then descriptive measures will be returned.
Otherwise absolute and relative frequencies will be returned. For using a subset of observation set \code{index}.
}
\examples{
# make sure that no other data sets are loaded
mmstat.set(datasets=NULL)
mmstat.getDataNames(mmstat.rds("CARS"))
# summary of first numeric variable in first data set in mmstat
var <- mmstat.getVar(1, 1, 'numeric')
mmstat.attrVar(var, "numeric")
# summary of first factor variable in first data set in mmstat
var <- mmstat.getVar(1, 1, 'factor')
mmstat.attrVar(var, 'factor')
}
