% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.fun.R
\name{scores.normalization}
\alias{scores.normalization}
\title{Scores normalization function}
\usage{
scores.normalization(norm.type = "maxnorm", S)
}
\arguments{
\item{norm.type}{can be one of the following two values:
\itemize{
\item maxnorm (\code{def.}): each score is divided w.r.t. the max of each class;
\item qnorm: a quantile normalization is applied. Package preprocessCore is used;
}}

\item{S}{A named flat scores matrix with examples on rows and classes on columns.}
}
\value{
The matrix of the scores flat normalized w.r.t. \code{maxnorm} or \code{qnorm}.
}
\description{
Normalize a scores matrix w.r.t. max normalization (\code{maxnorm}) or quantile normalization (\code{qnorm})
}
\details{
To apply the quantile normalization the \pkg{preprocessCore} package must be properly installed.
}
\examples{
data(scores);
norm.types <- c("maxnorm","qnorm");
for(norm.type in norm.types){
    scores.normalization(norm.type=norm.type, S=S);
}
}
