% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/AllMethod.R
\docType{methods}
\name{getDim}
\alias{getDim}
\alias{getDim,VB-method}
\alias{getDim,HMM-method}
\alias{getDim,HMMVB-method}
\title{Accessor for 'dim' slot}
\usage{
getDim(object)

\S4method{getDim}{VB}(object)

\S4method{getDim}{HMM}(object)

\S4method{getDim}{HMMVB}(object)
}
\arguments{
\item{object}{Object of class "VB", "HMM" or "HMMVB".}
}
\description{
This function outputs dimensionality.
}
\examples{
# accessing dim in instance of class VB
Vb <- vb(nb=2, dim=10, bdim=c(4,6), numst=c(3,11), varorder=list(c(1:4),c(5:10)))
getDim(Vb)

# accessing dim in instance of class HMM 
data("sim3")
Vb <- vb(2, dim=40, bdim=c(10,30), numst=c(3,5), varorder=list(c(1:10),c(11:40)))
set.seed(12345)
hmmvb <- hmmvbTrain(sim3[,1:40], VbStructure=Vb)
getDim(getHmmChain(hmmvb)[[1]])  
    
# accessing dim in instance of class HMMVB 
data("sim3")
Vb <- vb(2, dim=40, bdim=c(10,30), numst=c(3,5), varorder=list(c(1:10),c(11:40)))
set.seed(12345)
hmmvb <- hmmvbTrain(sim3[,1:40], VbStructure=Vb)
getDim(hmmvb)  
    
}
