% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/AllMethod.R
\docType{methods}
\name{getNumst}
\alias{getNumst}
\alias{getNumst,VB-method}
\alias{getNumst,HMM-method}
\alias{getNumst,HMMVB-method}
\title{Accessor for 'numst' slot}
\usage{
getNumst(object)

\S4method{getNumst}{VB}(object)

\S4method{getNumst}{HMM}(object)

\S4method{getNumst}{HMMVB}(object)
}
\arguments{
\item{object}{Object of class "VB", "HMM" or "HMMVB".}
}
\description{
This function outputs the number of states for each variable block in the variable block structure, 
the number of states of the HMM, or the number of states for each variable block of the HMM-VB.
}
\examples{
# accessing numst in instance of class VB
Vb <- vb(2, dim=10, bdim=c(4,6), numst=c(3,11), varorder=list(c(1:4),c(5:10)))
getNumst(Vb)

# accessing getNumst in instance of class HMM 
data("sim3")
Vb <- vb(2, dim=40, bdim=c(10,30), numst=c(3,5), varorder=list(c(1:10),c(11:40)))
set.seed(12345)
hmmvb <- hmmvbTrain(sim3[,1:40], VbStructure=Vb)
getNumst(getHmmChain(hmmvb)[[1]])  
    
# accessing numst in instance of class HMMVB 
data("sim3")
Vb <- vb(2, dim=40, bdim=c(10,30), numst=c(3,5), varorder=list(c(1:10),c(11:40)))
set.seed(12345)
hmmvb <- hmmvbTrain(sim3[,1:40], VbStructure=Vb)
getNumst(hmmvb)  
    
}
