% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDSpatialScan_print.R
\name{print.ResScanOutput}
\alias{print.ResScanOutput}
\title{Prints a result of a scan procedure}
\usage{
\method{print}{ResScanOutput}(x, ...)
}
\arguments{
\item{x}{ResScanOutput. Output of a scan function (UG, UNP, MG, MNP, PFSS, DFFSS, URBFSS, NPFSS, MPFSS, MDFFSS or MRBFSS)}

\item{...}{Further arguments to be passed to or from methods.}
}
\value{
No value returned, print the ResScanOutput object.
}
\description{
This function prints a result of a scan procedure.
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("funi_data")
coords <- coordinates(map_sites)

res_npfss <- SpatialScan(method = "NPFSS", data = funi_data, sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2)$NPFSS

print(x = res_npfss)}
\dontshow{
library(sp)
data("map_sites")
data("funi_data")
indices <- c(51:75)
coords <- coordinates(map_sites[indices,])
res_npfss <- SpatialScan(method = "NPFSS", data = funi_data[indices,],
sites_coord = coords, system = "WGS84", mini = 1, maxi = nrow(coords)/2,
MC = 99)$NPFSS
if(length(res_npfss$sites_clusters)>0){
print(x = res_npfss)
}

}

}
