% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{UH}
\alias{UH}
\title{Transfer function}
\usage{
UH(
  model,
  Qg,
  param
  )
}
\arguments{
\item{model}{numeric integer with the transfer function model. The current HBV.IANIGLA
model only allows for a single option.
\itemize{
  \item 1: triangular function with a static base.
}}

\item{Qg}{numeric vector with the water that gets into the stream.
If you are not modeling glaciers is the output of the
\code{\link{Routing_HBV}} module, otherwise, is the sum of the \code{\link{Routing_HBV}}
output plus the glacier discharge coming from the \code{\link{Glacier_Disch}} module.}

\item{param}{numeric vector with the following values,

\strong{Model 1}
\itemize{
  \item \code{Bmax}: base of the transfer function triangle \eqn{[timestep]}.
}}
}
\value{
Numeric vector with the simulated streamflow discharge.
}
\description{
Use a triangular transfer function to adjust the timing of the
simulated streamflow discharge. This module represents the runoff routing in
the streams.
}
\examples{
# The following is a toy example. I strongly recommend to see
# the package vignettes in order to improve your skills on HBV.IANIGLA

## Routing example
inputMatrix <- cbind(runif(n = 200, max = 100, min = 0), runif(n = 200, max = 50, min = 5),
                 runif(n = 100, max = 3, min = 1))

routeMod1   <- Routing_HBV(model = 1, lake = TRUE, inputData = inputMatrix,
                         initCond = c(10, 15, 20), param = c(0.1, 0.05, 0.001, 1, 0.8))

## UH
dischOut <- UH(model = 1, Qg = routeMod1[ , 1], param = 2.2)

}
\references{
Bergström, S., Lindström, G., 2015. Interpretation of runoff processes in hydrological
modelling—experience from the HBV approach. Hydrol. Process.
29, 3535–3545. https://doi.org/10.1002/hyp.10510

Parajka, J., Merz, R., & Blöschl, G. (2007). Uncertainty and multiple objective
calibration in regional water balance modelling: Case study in 320 Austrian catchments.
Hydrological Processes, 21(4), 435-446. https://doi.org/10.1002/hyp.6253
}
