% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{PET}
\alias{PET}
\title{Potential evapotranspiration models}
\usage{
PET(
  model,
  hemis,
  inputData,
  elev,
  param
  )
}
\arguments{
\item{model}{numeric value with model option:
\itemize{
  \item 1: Calder's model.
}}

\item{hemis}{numeric value indicating the hemisphere:
\itemize{
  \item 1: southern hemisphere.
  \item 2: northern hemisphere.
}}

\item{inputData}{numeric matrix with the following columns:

 \strong{Calder's model}
 \itemize{
  \item \code{column_1}: julian dates, e.g: \code{as.matrix( c(1:365) )}.
 }}

\item{elev}{numeric vector with the following values:

 \strong{Calder's model}
 \itemize{
  \item 1: \code{zref}: the reference height where potential evapotranspiration or
  input data to calculate PET is known.
  \item 2: \code{ztopo}: target PET's topographic height.
 }}

\item{param}{numeric vector with the following values:

\strong{Calder's model}
 \itemize{
  \item 1: \code{PET}: climatological daily mean potential evapotranspiration [mm].
  \item 2: \code{gradPET}: evapotranspiration decrease gradient [mm/100 m].
 }}
}
\value{
Numeric vector with the potential evapotranspiration series.
}
\description{
Calculate your potential evapotranspiration series. This module was
design to provide a simple and straight forward way to calculate
one of the inputs for the soil routine (to show how does it works), but for real
world application I strongly recommend the use of the specialized
\href{https://CRAN.R-project.org/package=Evapotranspiration}{\code{Evapotranspiration}}
package.
}
\examples{
# The following is a toy example. I strongly recommend to see
# the package vignettes in order to improve your skills on HBV.IANIGLA

## Run the model for a year in the southern hemisphere
potEvap <- PET(model = 1,
               hemis = 1,
               inputData = as.matrix(1:365),
               elev = c(1000, 1500),
               param = c(4, 0.5))

}
\references{
Calder, I.R., Harding, R.J., Rosier, P.T.W., 1983. An objective assessment of soil-moisture
deficit models. J. Hydrol. 60, 329–355. https://doi.org/10.1016/0022-1694(83)90030-6
}
