package de.fhg.iais.kd.djm.testing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;

import org.apache.log4j.PropertyConfigurator;

import de.fhg.iais.kd.djm.client.Client;
import de.fhg.iais.kd.djm.InputFile;
import de.fhg.iais.kd.djm.SSHClient;

import junit.framework.TestCase;


public class testing extends TestCase{

	public void testLog4J(){
		PropertyConfigurator.configureAndWatch( "log4j.properties", 60*1000 );
	}
	//String ip ="localhost";
	String ip ="grid-node1";
	int port = 4444;
	
public void xtestDownloadFiles() throws IOException{
		ArrayList<InputFile> remFiles = new ArrayList<InputFile>();
		//remFiles.add(new InputFile("/home/mlohmeyer/AffyRes.zip"));
		remFiles.add(new InputFile("/home/mlohmeyer/GSM.CEL"));
		remFiles.add(new InputFile("/home/mlohmeyer/Windows XP Professional.vmem"));
		//remFiles.add(new InputFile("/home/mlohmeyer/test.Rout"));
		//remFiles.add(new InputFile("C:/Dokumente und Einstellungen/dwegener/Desktop/jdk-1_5_0_05-windows-i586-p.exe"));
		//remFiles.add(new InputFile("C:/Dokumente und Einstellungen/dwegener/Desktop/hs_err_pid792.log"));
		Client.downloadFiles(ip, port, "grid", remFiles, "mlohmeyer");
	}

	public void xtestUploadFiles() throws IOException{
		
		ArrayList<InputFile> files = new ArrayList<InputFile>();
		files.add(new InputFile("/home/mlohmeyer/GSM.CEL"));
		files.add(new InputFile("/home/mlohmeyer/test.Rout"));
		
		Client.uploadFiles(ip, port, "grid", files, "mlohmeyer");
	}
	
	public void testStopJob() throws Exception{

		Socket sock = new Socket("localhost",4444);
		
		BufferedReader in = new BufferedReader(new InputStreamReader(
				sock.getInputStream()));
		BufferedWriter out = new BufferedWriter(new OutputStreamWriter(sock
				.getOutputStream()));
		String jobid="0";
		out.write("<job>\n<mode>stopJob</mode>\n<username>mlohmeyer</username>\n<id>"+ jobid +"</id>\n</job>\n");
		out.flush();
		
		out.close();
		in.close();
		sock.close();
		
		}
	
	public void xtestConnection() throws UnknownHostException, IOException{
		
		Socket sock = new Socket("localhost",4444);
		BufferedReader in = new BufferedReader(new InputStreamReader(
				sock.getInputStream()));
		BufferedWriter out = new BufferedWriter(new OutputStreamWriter(sock
				.getOutputStream()));
		
		out.close();
		in.close();
		
		sock.close();
	}
	
	
	
	public void xtestRExec() throws Exception{
		String hostname = "grid-node4";
		String username= "mlohmeyer";
		String key ="/home/mlohmeyer/.ssh/id_rsa";
		//upload files
		SSHClient client = new SSHClient(hostname, username, key);
		client.connect();
		client.upload(new String[]{"files/grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R", "files/grid-linux-9nop-16653-2008-11-10-12-41-47-0-fx"}, "grid2");
		client.close();
		Socket sock = new Socket("localhost",4444);
		
		BufferedReader in = new BufferedReader(new InputStreamReader(
				sock.getInputStream()));
		BufferedWriter out = new BufferedWriter(new OutputStreamWriter(sock
				.getOutputStream()));

		out.write("<job>\n<mode>execFile</mode>\n<username>mlohmeyer</username>\n<executable>R</executable>\n<arguments>CMD BATCH grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R</arguments>\n <remoteDir> grid2</remoteDir>\n<execIp>grid-node4</execIp>\n<outputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-y.dat</outputFile>\n<outputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.Rout</outputFile>\n<inputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-fx</inputFile>\n<inputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R</inputFile>\n<block>false</block>\n</job>\n");
		out.flush();
		int id = Integer.valueOf(in.readLine());
		
		out.close();
		in.close();
		sock.close();
		
		//wait until result is there		
		Client.waitForResult("localhost", 4444, "mlohmeyer", id);
		
		//print files on server
		client = new SSHClient(hostname, username, key);
		client.connect();
		System.out.println(client.send("cd grid2 && ls -l\n"));
		client.close();
		
		//delete Job on Server
		Client.deleteJobOnServer("localhost", 4444, "mlohmeyer", id);
		Thread.sleep(500); //otherwise the files of the next job are deleted, because all files of every testcase are the same
	}
	
	
	public void xtestRExecBlocking() throws Exception{
		String hostname = "grid-node4";
		String username= "mlohmeyer";
		String key ="/home/mlohmeyer/.ssh/id_rsa";
		//upload files
		SSHClient client = new SSHClient(hostname, username, key);
		client.connect();
		client.upload(new String[]{"files/grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R", "files/grid-linux-9nop-16653-2008-11-10-12-41-47-0-fx"}, "grid2");
		client.close();
		Socket sock = new Socket("localhost",4444);
		
		BufferedReader in = new BufferedReader(new InputStreamReader(
				sock.getInputStream()));
		BufferedWriter out = new BufferedWriter(new OutputStreamWriter(sock
				.getOutputStream()));
		
		out.write("<job>\n<mode>execFile</mode>\n<username>mlohmeyer</username>\n<executable>R</executable>\n<arguments>CMD BATCH grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R</arguments>\n <remoteDir> /home/mlohmeyer/grid2</remoteDir>\n<execIp>grid-node4</execIp>\n<outputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-y.dat</outputFile>\n<outputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.Rout</outputFile>\n<inputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-fx</inputFile>\n<inputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R</inputFile>\n<block>true</block>\n</job>\n");
		out.flush();
		int id = Integer.valueOf(in.readLine());
		String data;
		while((data=in.readLine())!=null)
			System.out.println(data);
		out.close();
		in.close();
		sock.close();
		
		//print files on server
		client = new SSHClient(hostname, username, key);
		client.connect();
		System.out.println(client.send("cd grid2 && ls -l\n"));
		client.close();
		
		//delete Job on Server
		Client.deleteJobOnServer("localhost", 4444, "mlohmeyer", id);
		
		Thread.sleep(500); //otherwise the files of the next job are deleted, because all files of every testcase are the same
	}
	

	public void xtestCondor() throws Exception{
		String hostname = "grid-node2";
		String username= "mlohmeyer";
		String key ="/home/mlohmeyer/.ssh/id_rsa";
		//upload files
		SSHClient client = new SSHClient(hostname, username, key);
		client.connect();
		client.upload(new String[]{"files/grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R", "files/grid-linux-9nop-16653-2008-11-10-12-41-47-0-fx"}, "grid");
		client.close();
		Socket sock = new Socket("localhost",4444);
		
		BufferedReader in = new BufferedReader(new InputStreamReader(
				sock.getInputStream()));
		BufferedWriter out = new BufferedWriter(new OutputStreamWriter(sock
				.getOutputStream()));		
		out.write("<job>\n<mode>execCondorJob</mode>\n<username>mlohmeyer</username>\n<executable>/usr/bin/R</executable>\n<arguments>CMD BATCH grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R</arguments>\n <remoteDir> grid</remoteDir>\n<execIp>"+hostname+"</execIp>\n<outputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-y.dat</outputFile>\n<outputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.Rout</outputFile>\n<inputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-fx</inputFile>\n<inputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R</inputFile>\n<block>false</block>\n</job>\n");
		out.flush();
		int id = Integer.valueOf(in.readLine());
		out.close();
		in.close();
		sock.close();
		
		//wait until result is there		
		Client.waitForResult("localhost", 4444, "mlohmeyer", id);
		
		//print files on server
		client = new SSHClient(hostname, username, key);
		client.connect();
		System.out.println(client.send("cd grid2 && ls -l\n"));
		client.close();
		
		//delete Job on Server
		Client.deleteJobOnServer("localhost", 4444, "mlohmeyer", id);
		Thread.sleep(500); //otherwise the files of the next job are deleted, because all files of every testcase are the same	
	}

	
	public void xtestCondorBlocking() throws Exception{
		String hostname = "grid-node4";
		String username= "mlohmeyer";
		String key ="/home/mlohmeyer/.ssh/id_rsa";
		//upload files
		SSHClient client = new SSHClient(hostname, username, key);
		client.connect();
		client.upload(new String[]{"files/grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R", "files/grid-linux-9nop-16653-2008-11-10-12-41-47-0-fx"}, "grid2");
		client.close();
		Socket sock = new Socket("localhost",4444);
		
		BufferedReader in = new BufferedReader(new InputStreamReader(
				sock.getInputStream()));
		BufferedWriter out = new BufferedWriter(new OutputStreamWriter(sock
				.getOutputStream()));		
		out.write("<job>\n<mode>execCondorJob</mode>\n<username>mlohmeyer</username>\n<executable>/usr/bin/R</executable>\n<arguments>CMD BATCH grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R</arguments>\n <remoteDir> /home/mlohmeyer/grid2</remoteDir>\n<execIp>grid-node4</execIp>\n<outputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-y.dat</outputFile>\n<outputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.Rout</outputFile>\n<inputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-fx</inputFile>\n<inputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R</inputFile>\n<block>true</block>\n</job>\n");
		out.flush();
		int id = Integer.valueOf(in.readLine());
		System.out.println(id);
		String data;
		while((data=in.readLine())!=null)
			System.out.println(data);
		out.close();
		in.close();
		sock.close();
		
		
		//print files on server
		client = new SSHClient(hostname, username, key);
		client.connect();
		System.out.println(client.send("cd grid2 && ls -l\n"));
		client.close();
		
		//delete Job on Server
		Client.deleteJobOnServer("localhost", 4444, "mlohmeyer", id);
		
		Thread.sleep(500); //otherwise the files of the next job are deleted, because all files of every testcase are the same
	}
	
	
	public void xtestGlobus() throws Exception{
		String hostname = "kd-8";
		String username= "mlohmeyer";
		String key ="/home/mlohmeyer/.ssh/id_rsa";
		
		//upload files
		SSHClient client = new SSHClient(hostname, username, key);
		client.connect();

		
		Socket sock = new Socket("localhost",4444);
		
		BufferedReader in = new BufferedReader(new InputStreamReader(
				sock.getInputStream()));
		BufferedWriter out = new BufferedWriter(new OutputStreamWriter(sock
				.getOutputStream()));		
		out.write("<job>\n<mode>execGlobusJob</mode>\n<username>"+username+"</username>\n<executable>/usr/bin/R</executable>\n<arguments>CMD BATCH grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R</arguments>\n <remoteDir> /home/mlohmeyer/grid</remoteDir>\n<execIp>"+hostname +"</execIp>\n<inputFile>gsiftp://kd-9/home/mlohmeyer/grid/grid-linux-9nop-16653-2008-11-10-12-41-47-0-fx</inputFile>\n<inputFile>gsiftp://kd-9/home/mlohmeyer/grid/grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.R</inputFile>\n<block>false</block>\n<outputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-y.dat</outputFile>\n<outputFile>grid-linux-9nop-16653-2008-11-10-12-41-47-0-script.Rout</outputFile>\n</job>\n");
		out.flush();
		int id = Integer.valueOf(in.readLine());
		
		out.close();
		in.close();
		sock.close();
		
		//wait until result is there		
		Client.waitForResult("localhost", 4444, "mlohmeyer", id);
		
		//print files on server
		client = new SSHClient(hostname, username, key);
		client.connect();
		System.out.println(client.send("cd grid && ls -l\n"));
		client.close();
		
		//delete Job on Server
		Client.deleteJobOnServer("localhost", 4444, "mlohmeyer", id);
		Thread.sleep(500); //otherwise the files of the next job are deleted, because all files of every testcase are the same
		
	}
	
}