/*
 * Decompiled with CFR 0.152.
 */
package GurobiNumericalOptimizeExperimentalDesign;

import ExperimentalDesign.AllExperimentalDesigns;
import gurobi.GRB;
import gurobi.GRBEnv;
import gurobi.GRBException;
import gurobi.GRBExpr;
import gurobi.GRBLinExpr;
import gurobi.GRBModel;
import gurobi.GRBQuadExpr;
import gurobi.GRBVar;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class GurobiNumericalOptimizeExperimentalDesign
extends AllExperimentalDesigns {
    private int[][] indicator_T;
    private Double time_limit_min;
    private Integer node_limit;
    private Integer max_solutions;
    private boolean gurobi_log_off;
    private String log_file;

    public static void main(String[] stringArray) {
        GurobiNumericalOptimizeExperimentalDesign gurobiNumericalOptimizeExperimentalDesign = new GurobiNumericalOptimizeExperimentalDesign();
        gurobiNumericalOptimizeExperimentalDesign.rand_obj.setSeed(1984L);
        int n = 100;
        int n2 = 10;
        try {
            gurobiNumericalOptimizeExperimentalDesign.setNandP(n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n2];
            for (int j = 0; j < n2; ++j) {
                dArray[j] = gurobiNumericalOptimizeExperimentalDesign.rand_obj.nextDouble();
            }
            gurobiNumericalOptimizeExperimentalDesign.setDataRow(i, dArray);
        }
        gurobiNumericalOptimizeExperimentalDesign.setNumCores(3);
        gurobiNumericalOptimizeExperimentalDesign.setWait();
        gurobiNumericalOptimizeExperimentalDesign.beginSearch();
    }

    @Override
    public void beginSearch() {
        int n;
        super.beginSearch();
        GRBEnv gRBEnv = null;
        try {
            gRBEnv = new GRBEnv();
        }
        catch (GRBException gRBException) {
            System.err.println("Gurobi error when creating the environment. Error code: " + gRBException.getErrorCode());
            gRBException.printStackTrace();
        }
        try {
            gRBEnv.set(GRB.StringParam.LogFile, this.log_file);
        }
        catch (GRBException gRBException) {
            System.err.println("Gurobi error when setting the log file. Error code: " + gRBException.getErrorCode());
            gRBException.printStackTrace();
        }
        try {
            gRBEnv.set(GRB.IntParam.Threads, this.num_cores.intValue());
        }
        catch (GRBException gRBException) {
            System.err.println("Gurobi error when setting the number of cores. Error code: " + gRBException.getErrorCode());
            gRBException.printStackTrace();
        }
        if (this.gurobi_log_off) {
            try {
                gRBEnv.set(GRB.IntParam.LogToConsole, 0);
            }
            catch (GRBException gRBException) {
                System.err.println("Gurobi error when turning off console log. Error code: " + gRBException.getErrorCode());
                gRBException.printStackTrace();
            }
        }
        GRBModel gRBModel = null;
        try {
            gRBModel = new GRBModel(gRBEnv);
        }
        catch (GRBException gRBException) {
            System.err.println("Gurobi error when creating the model. Error code: " + gRBException.getErrorCode());
            gRBException.printStackTrace();
        }
        if (this.time_limit_min != null) {
            try {
                gRBModel.set(GRB.DoubleParam.TimeLimit, this.time_limit_min * 60.0);
            }
            catch (GRBException gRBException) {
                System.err.println("Gurobi error when setting the time limit. Error code: " + gRBException.getErrorCode());
                gRBException.printStackTrace();
            }
        }
        if (this.node_limit != null) {
            try {
                gRBModel.set(GRB.DoubleParam.NodeLimit, (double)this.node_limit.intValue());
            }
            catch (GRBException gRBException) {
                System.err.println("Gurobi error when setting the time limit. Error code: " + gRBException.getErrorCode());
                gRBException.printStackTrace();
            }
        }
        if (this.max_solutions != null) {
            try {
                gRBModel.set(GRB.IntParam.PoolSolutions, this.max_solutions.intValue());
            }
            catch (GRBException gRBException) {
                System.err.println("Gurobi error when setting the maximum number of solutions. Error code: " + gRBException.getErrorCode());
                gRBException.printStackTrace();
            }
        }
        SimpleMatrix simpleMatrix = new SimpleMatrix(this.X);
        SimpleMatrix simpleMatrix2 = new SimpleMatrix(this.Sinv);
        SimpleMatrix simpleMatrix3 = (SimpleMatrix)((SimpleMatrix)simpleMatrix.mult((SimpleBase)simpleMatrix2)).mult(simpleMatrix.transpose());
        GRBVar[] gRBVarArray = new GRBVar[this.n];
        for (int i = 0; i < this.n; ++i) {
            try {
                gRBVarArray[i] = gRBModel.addVar(0.0, 1.0, 0.0, 'B', Integer.toString(i));
                continue;
            }
            catch (GRBException gRBException) {
                System.err.println("Gurobi error when setting the time limit for observation #" + i + " Error code: " + gRBException.getErrorCode());
                gRBException.printStackTrace();
            }
        }
        GRBQuadExpr gRBQuadExpr = new GRBQuadExpr();
        for (int i = 0; i < this.n; ++i) {
            for (n = 0; n < this.n; ++n) {
                gRBQuadExpr.addTerm(1000000.0 * simpleMatrix3.get(i, n), gRBVarArray[i], gRBVarArray[n]);
            }
        }
        try {
            gRBModel.setObjective((GRBExpr)gRBQuadExpr);
        }
        catch (GRBException gRBException) {
            System.err.println("Gurobi error when setting the objective function in the model. Error code: " + gRBException.getErrorCode());
            gRBException.printStackTrace();
        }
        GRBLinExpr gRBLinExpr = new GRBLinExpr();
        for (n = 0; n < this.n; ++n) {
            gRBLinExpr.addTerm(1.0, gRBVarArray[n]);
        }
        try {
            gRBModel.addConstr(gRBLinExpr, '=', (double)(this.n / 2), "c0");
        }
        catch (GRBException gRBException) {
            System.err.println("Gurobi error when setting the constraint of equal treatments and equal controls. Error code: " + gRBException.getErrorCode());
            gRBException.printStackTrace();
        }
        try {
            gRBModel.optimize();
        }
        catch (GRBException gRBException) {
            System.err.println("Gurobi error when running the optimization algorithm. Error code: " + gRBException.getErrorCode());
            gRBException.printStackTrace();
        }
        int n2 = 1;
        try {
            n2 = gRBModel.get(GRB.IntAttr.SolCount);
        }
        catch (GRBException gRBException) {
            System.err.println("Gurobi error when querying the number of solutions. Error code: " + gRBException.getErrorCode());
            gRBException.printStackTrace();
        }
        this.indicator_T = new int[n2][this.n];
        for (int i = 0; i < n2; ++i) {
            int n3;
            try {
                gRBModel.set(GRB.IntParam.SolutionNumber, i);
            }
            catch (GRBException gRBException) {
                System.err.println("Gurobi error when setting the solution number to: " + (i + 1) + " of " + n2 + " solutions. Error code: " + gRBException.getErrorCode());
                gRBException.printStackTrace();
            }
            for (n3 = 0; n3 < this.n; ++n3) {
                this.indicator_T[i][n3] = -99;
            }
            for (n3 = 0; n3 < this.n; ++n3) {
                try {
                    this.indicator_T[i][n3] = (int)gRBVarArray[n3].get(GRB.DoubleAttr.X);
                    continue;
                }
                catch (GRBException gRBException) {
                    System.err.println("Gurobi error when extracting the solution for vector element #" + n3 + " for solution # " + (i + 1) + ". Error code: " + gRBException.getErrorCode());
                    gRBException.printStackTrace();
                }
            }
        }
        gRBModel.dispose();
        try {
            gRBEnv.dispose();
        }
        catch (GRBException gRBException) {
            System.err.println("Gurobi error when disposing of the environment. Error code: " + gRBException.getErrorCode());
            gRBException.printStackTrace();
        }
    }

    public void turnGurobiLogOff() {
        this.gurobi_log_off = true;
    }

    public void setLogFilename(String string) {
        this.log_file = string;
    }

    public void setTimeLimitMin(double d) {
        this.time_limit_min = d;
    }

    public void setTimeLimitMin(int n) {
        this.node_limit = n;
    }

    public void setMaxSolutions(int n) {
        this.max_solutions = n;
    }

    public int[] getBestIndicT() {
        return this.indicator_T[0];
    }

    @Override
    public void setObjective(String string) throws Exception {
        if (string.equals("mahal_dist")) {
            throw new Exception("For Numerical Optimization, Mahalanobis is the only implemented objective function.");
        }
        this.objective = string;
    }
}

