% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs_align.R
\name{align}
\alias{align}
\alias{alignVertical}
\alias{alignHorizontal}
\title{Align boxes}
\usage{
alignVertical(reference, ..., .position = c("center", "top", "bottom"))

alignHorizontal(
  reference,
  ...,
  .position = c("center", "left", "right"),
  .sub_position = c("none", "left", "right")
)
}
\arguments{
\item{reference}{A \code{\link{boxGrob}}/\code{\link{boxPropGrob}}/\code{\link{coords}} object or a \code{\link[grid:unit]{unit}} or a
numerical value that can be converted into a \code{\link[grid:unit]{unit}} of \code{npc} type.}

\item{...}{A set of boxes.}

\item{.position}{How to align the boxes, differs slightly for vertical and horizontal alignment
see the accepted arguments}

\item{.sub_position}{When the box is a \code{\link{boxPropGrob}} it not only has the general \code{.positions} but
also \code{left} and \code{right} which can be viewed as separate boxes that have simply been merged.}
}
\value{
\code{list} with the boxes that are to be aligned
}
\description{
Aligns a set of \code{\link{boxGrob}}/\code{\link{boxPropGrob}} according to the first positional argument.
}
\examples{
library(grid)
grid.newpage()

box <- boxGrob("A cool\nreference\nbox",
               x = .5, y = .8,
               box_gp = gpar(fill = "#ADB5C7"))
another_box <- boxGrob("A horizontal box", x = .1, y =  .5)
yet_another_box <- boxGrob("Another horizontal box", x = .8, y = .3)

alignedBoxes <- alignHorizontal(box,
                                another_box,
                                yet_another_box,
                                .position = "right")

box
for (b in alignedBoxes) {
  print(b)
}


vert_box <- boxGrob("Vert", 
                    x = .8, y = .3,
                    box_gp = gpar(fill = "darkgreen"),
                    txt_gp = gpar(col = "white"))
another_vert_box <- boxGrob("Another vertical", 
                            x = .1, y =  .5,
                            box_gp = gpar(fill = "darkgreen"),
                            txt_gp = gpar(col = "white"))

alignedBoxes <- alignVertical(box,
                              vert_box,
                              another_vert_box,
                              .position = "bottom")
for (b in alignedBoxes) {
  print(b)
}
}
\seealso{
Other flowchart components: 
\code{\link{boxGrob}()},
\code{\link{boxPropGrob}()},
\code{\link{connectGrob}()},
\code{\link{coords}()},
\code{\link{distance}()},
\code{\link{moveBox}()},
\code{\link{spread}}
}
\concept{flowchart components}
