% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ld_decay.R
\name{ld_decay}
\alias{ld_decay}
\title{Evaluation of Linkage Disequilibrium Decay}
\usage{
ld_decay(gen = gen, map = map, max_win_snp = 2000,
  max.chr = max.chr, cores = 1, max_r2 = max_r2)
}
\arguments{
\item{gen}{Matrix of genotype data. Individuals in rows, genotypes (0, 1, 2) in columns.}

\item{map}{Dataframe inculding the name for each marker with a corresponding chromosome number and physical position.}

\item{max_win_snp}{The maximum number of markers in each window. Sets the maximum number of markers allowed per window within a chromosome before estimating the LD. Default is 2000.}

\item{max.chr}{Chromosomes above this number will be excluded from the analysis.}

\item{cores}{Numer of cores for using parallelized calculation, Default is 1 for windows machine.}

\item{max_r2}{the threshold of r^2 to calculate the effective number of independent markers.}
}
\value{
cor: Correlation matrix

ch_eff_nmark: The Number of independent marker per chromosome

eff_nmark: The effective number of independent markers
}
\description{
ld_decay: R function for calculating the effective number of independent markers
}
\examples{
\donttest{
library("parallel")
gen         <- Maize_wqs[[4]]
map         <- Maize_wqs[[3]]
Res_ld <- ld_decay (gen=gen, map=map, max_win_snp=2000,
                    max.chr=10, cores=1, max_r2=0.03)
}                     
                    
}
